/* 
 *  ttyuser.c - utmp and wtmp relayted functions.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "getstatd.h"

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Determine user name using IP address. */

char * make_user_name (struct sockaddr_in cli_addr){
       char * ip_addr;
       str_array * str_pnt;
       int J,K, ip_size;
       FILE * auth_file;
       char cur_tty[BUF_SIZE+1];
       char buff[BUF_SIZE+1];
   
    ip_addr = inet_ntoa(cli_addr.sin_addr);
    str_pnt = ipallow;
    while (str_pnt != NULL){
	ip_size = strlen(ip_addr);
	for (J=0;( str_pnt->item[J] != '\0') && ( str_pnt->item[J] != ':'); J++){;}
	if (ip_size < J){
	    ip_size = J;
	}
	if ( strncmp(ip_addr, str_pnt->item, ip_size) == 0){
	    if (str_pnt->item[J] == '\0'){
	       return NULL;
	    }
	    J++;
	    for (K=0; ( str_pnt->item[J] != '\0')&&(K < BUF_SIZE); J++,K++){
	        cur_tty[K] = str_pnt->item[J];
	    }         
	    cur_tty[K] ='\0';    

	    if (strncasecmp(cur_tty,"auto",4)==0){
/* AUTO USER */
		snprintf(buff, BUF_SIZE, "%s/%s",autoauthdir,ip_addr);

		if ( (auth_file = fopen(buff,"r")) == NULL){
		    log_info("Can't open IP->USER identification file.");
		    return NULL;
		}

		if ( fgets ( buff, BUF_SIZE, auth_file ) != NULL){
		    strncpy(user_name, buff, BUF_SIZE);
		    user_name[BUF_SIZE] = '\0';
		    fclose(auth_file);
		    return user_name;
		}
		fclose(auth_file);
		return NULL;
	    }
	    return get_tty_user(cur_tty, user_name);
	} 
	str_pnt=str_pnt->next;
   }

   return NULL;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Determine IP address using user name. */

char * ip_name ( char * tty_name ){
        str_array * str_pnt;
        int J;
	FILE * auth_file;       
        char buff[BUF_SIZE+1];
	
    cur_ip[0]='\0';
    str_pnt = ipallow;

    while (str_pnt != NULL){
	for (J=0;( str_pnt->item[J] != '\0') && ( str_pnt->item[J] != ':'); J++){;}
	if (str_pnt->item[J] == '\0'){
	   return NULL;
	}
	J++;
	if ( J > BUF_SIZE){
	   return NULL;
	}

	if ( strncmp(tty_name, (str_pnt->item)+J, UT_LINESIZE) == 0){
	    strncpy(cur_ip,str_pnt->item,J-1);
	    cur_ip[J-1] = '\0';
	    return cur_ip;
	}

	if ( strncasecmp((str_pnt->item)+J, "auto",4) == 0){
/* AUTO IP */
		strncpy(cur_ip,str_pnt->item,J-1);
		cur_ip[J-1] = '\0';
		snprintf(buff, BUF_SIZE, "%s/%s", autoauthdir, cur_ip);

		if ( (auth_file = fopen(buff,"r")) != NULL){

		    if ( fgets ( buff, BUF_SIZE, auth_file ) != NULL){

			if ( get_tty_user( tty_name, user_name) != NULL){

			    if (strncasecmp(user_name, buff, UT_NAMESIZE) == 0){
				fclose(auth_file);
				return cur_ip;
			    }
			}
		    }
		    fclose(auth_file);
		}
		cur_ip[0] = '\0';
	}
	str_pnt=str_pnt->next;
   }

   return NULL;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Determine user name using trminal name. */

char * get_tty_user(char *tty_name, char *user_name){
	 struct utmp * cur_utmp;
	 FILE * utmp_file;
	 char * buff = (char *) malloc ( BUF_SIZE+1 );
	 
    cur_utmp = (struct utmp *)malloc(sizeof(struct utmp));

    if ( (utmp_file = fopen(utmp_path,"r")) == NULL){
	log_error("Can't open utmp file.");
    }

    user_name[0] = '\0';

    while (fread(cur_utmp, sizeof(struct utmp),1,utmp_file)){

	if ( strncmp( cur_utmp->ut_line, tty_name, UT_LINESIZE) == 0){
	    strncpy(user_name, cur_utmp->ut_name, UT_NAMESIZE);
	    user_name[UT_NAMESIZE] = '\0';
	    break;
	}
    }

    if ((user_name[0] == '\0')||(strncmp(user_name, "LOGIN", 5)==0)){
	  strncpy(user_name,"NOUSER",6);    
          user_name[6] = '\0';
          snprintf (buff, BUF_SIZE, "no such user on tty [%s]", tty_name);
          log_info(buff);
	  fclose(utmp_file);
          free(cur_utmp);
	  free (buff);
	  return NULL;
    }	 

    fclose(utmp_file);
    free(cur_utmp);
    free (buff);
    return user_name;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Who is online. */

void who_is_on(void){
	 struct utmp * cur_utmp;
	 time_t	cur_time;
	 char * time_beg;
	 FILE * utmp_file;
	 char * buff = (char *) malloc ( BUF_SIZE+1 );
   	 str_array * str_pnt;
	 char user_name[UT_NAMESIZE+1];
	 char tty_name[UT_LINESIZE+1];
	 char * sub_str;

    cur_utmp = (struct utmp *)malloc(sizeof(struct utmp));
    
    if ( (utmp_file = fopen(utmp_path,"r")) == NULL){
	log_error("Can't open utmp file.");
    }

    while (fread(cur_utmp, sizeof(struct utmp), 1, utmp_file)){

        str_pnt = calctty;

	while (str_pnt != NULL){

    	    if( (sub_str = strchr(str_pnt->item, '*' )) != NULL ){
		if (strncmp(cur_utmp->ut_line, str_pnt->item, (sub_str-str_pnt->item-1 ) ) == 0){
		    /* user	tty (IP) logdate - curdate */
		    time (&cur_time);
		    strncpy(user_name, cur_utmp->ut_name, UT_NAMESIZE);
		    user_name[UT_NAMESIZE] = '\0';
		    strncpy(tty_name, cur_utmp->ut_line, UT_LINESIZE);
		    tty_name[UT_LINESIZE] = '\0';
		    ip_name(tty_name);
		    time_beg = ctime(&(cur_utmp->ut_time));
		    time_beg[strlen(time_beg)-1]='\0';
		    snprintf (buff,BUF_SIZE, "%-8.8s  %-6.6s (%-15.15s)  %-5.d\t%s - ", user_name, tty_name,cur_ip,(cur_time - cur_utmp->ut_time)/60,time_beg);

		    if ((strncmp(user_name,"LOGIN",5) != 0) && (user_name[0] != '\0')) {
			prints(buff);
			snprintf (buff,BUF_SIZE, "%s", ctime(&cur_time));
			prints(buff);
		    }
       		}
	    } else {
		if (strncmp(cur_utmp->ut_line, str_pnt->item, UT_LINESIZE) == 0){
		    /* user	tty (IP) logdate - curdate */
		    time (&cur_time);
		    strncpy(user_name, cur_utmp->ut_name, UT_NAMESIZE);
		    user_name[UT_NAMESIZE] = '\0';
		    strncpy(tty_name, cur_utmp->ut_line, UT_LINESIZE);
		    tty_name[UT_LINESIZE] = '\0';
		    ip_name(tty_name);
		    time_beg = ctime(&(cur_utmp->ut_time));
		    time_beg[strlen(time_beg)-1]='\0';
		    snprintf (buff,BUF_SIZE, "%-8.8s  %-6.6s (%-15.15s)  %-5.d\t%s - ", user_name, tty_name,cur_ip,(cur_time - cur_utmp->ut_time)/60,time_beg);

		    if ((strncmp(user_name,"LOGIN",5) != 0) && (user_name[0] != '\0')) {
			prints(buff);
			snprintf (buff,BUF_SIZE, "%s", ctime(&cur_time));
			prints(buff);
		    }
        	}
	    }
    	    str_pnt=str_pnt->next;
        } 
    }

    fclose(utmp_file);
    free (buff);
    free(cur_utmp);
}
