/* 
 *  system.c - Useful functions.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include	"getstatd.h"

const int pr2six[256]={
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,62,64,64,64,63,
    52,53,54,55,56,57,58,59,60,61,64,64,64,64,64,64,64,0,1,2,3,4,5,6,7,8,9,
    10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,64,64,64,64,64,64,26,27,
    28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
    64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,
    64,64,64,64,64,64,64,64,64,64,64,64,64
};

ignore_list * ignore_userlist;
long	* coop_tty;

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Read block from socket */

int readline(int fd, char *ptr, int maxlen){

	int	n, rc;
	char	c;

    for (n = 1; n < maxlen; n++) {

    	if ( (rc = read(fd, &c, 1)) == 1) {
		*ptr++ = c;
		if (c == '\n'){
			break;
		}
	} else if (rc == 0) {

	       if (n == 1){
			return 0;
	       } else {
			break;
	       }	
	} else {
		return -1;
	}
    }

	*ptr = 0;
	return n;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Write block to socket */

int writeline(int fd, char *ptr){

	int	nleft, nwritten;
        int nbytes;

    nbytes = strlen(ptr);
    nleft = nbytes;
    while (nleft > 0) {

	nwritten = write(fd, ptr, nleft);
	/* nwritten = send(fd, ptr, nleft,0); */

	if (nwritten <= 0){
		return nwritten;
	}
	nleft -= nwritten;
	ptr   += nwritten;
    }
    return nbytes - nleft;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Write data to default socket */

void prints( char *ptr){
   writeline(gen_socket, ptr);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Put information message to syslog */

void log_info(char *str){

    openlog("getstatd", LOG_PID, LOG_DAEMON);
    syslog(LOG_INFO, str);
    closelog();
}
/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Put error message to syslog and halt */

void log_error(char *str){

    openlog("getstatd", LOG_PID | LOG_CONS, LOG_DAEMON);
    syslog(LOG_ERR, str);
    syslog(LOG_ERR, "Exiting....");
    closelog();	
    fprintf(stderr,"getstatd error:%s\n",str);
    exit(1);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Fetching from Apache httpd uudecode function */

char *uudecode( char *bufcoded) {
    int nbytesdecoded;
    register unsigned char *bufin;
    register char *bufplain;
    register unsigned char *bufout;
    register int nprbytes;
    
    /* Strip leading whitespace. */
    
    while(*bufcoded==' ' || *bufcoded == '\t') bufcoded++;
    
    /* Figure out how many characters are in the input buffer.
     * Allocate this many from the per-transaction pool for the result.
     */
    bufin = (unsigned char *)bufcoded;
    while(pr2six[*(bufin++)] <= 63);
    nprbytes = (char *)bufin - bufcoded - 1;
    nbytesdecoded = ((nprbytes+3)/4) * 3;

    bufplain = (char *)malloc(nbytesdecoded + 1);
    bufout = (unsigned char *)bufplain;
    
    bufin = (unsigned char *)bufcoded;
    
    while (nprbytes > 0) {
        *(bufout++) = 
            (unsigned char) (pr2six[*bufin] << 2 | pr2six[bufin[1]] >> 4);
        *(bufout++) = 
            (unsigned char) (pr2six[bufin[1]] << 4 | pr2six[bufin[2]] >> 2);
        *(bufout++) = 
            (unsigned char) (pr2six[bufin[2]] << 6 | pr2six[bufin[3]]);
        bufin += 4;
        nprbytes -= 4;
    }
    
    if(nprbytes & 03) {
        if(pr2six[bufin[-2]] > 63)
            nbytesdecoded -= 2;
        else
            nbytesdecoded -= 1;
    }
    bufplain[nbytesdecoded] = '\0';
    return bufplain;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Same as bzero. */

void fill_null( char * str ){
	int I;

    for (I=0; str[I] != '\0'; I++){
	str[I] = ' ';
    }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Translate any time to midnight time. This method doesn't work well :( */

time_t make_utc_time (time_t user_time, int night_time){
	struct tm * night_tm = (struct tm *)malloc(sizeof(struct tm));  
	struct tm * user_tm;
	time_t long_night;

    user_tm = localtime(&user_time);
    /* user_tm = gmtime(&user_time); */

    night_tm->tm_sec = 0;
    night_tm->tm_min = 0;
    night_tm->tm_hour = 0;
    night_tm->tm_mday = user_tm->tm_mday;
    night_tm->tm_mon = user_tm->tm_mon;
    night_tm->tm_year = user_tm->tm_year;

    long_night = user_time/(60*60);
    long_night = long_night*60*60 + night_time*60*60 - user_tm->tm_hour*60*60;

    if ((user_tm->tm_hour < 12) && (night_time > 12)){
	long_night -= 60*60*24;
    }
    if ((user_tm->tm_hour > 12) && (night_time < 12)){
	long_night += 60*60*24;
    }

    free(night_tm);

    return long_night;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void prepare_lists(void){
	FILE * listfile;
	char cur_user[BUF_SIZE+1];
	char * str_ptr;
	char * newstr;
	ignore_list * point_arr;
	ignore_list ** cur_next;
	int I;

    ignore_userlist = NULL;
    cur_next = &(ignore_userlist);

    if ( (listfile = fopen(ignoreusers, "r")) == NULL) {
	log_info("Can't open ignorelist file.");
	return;
    }
    
    while ( fgets( cur_user, BUF_SIZE, listfile) != NULL ){

	str_ptr = strpbrk(cur_user, DILIMERS);

	if (str_ptr != NULL){
	    str_ptr[0] = '\0';
	} 

    	if (cur_user[0] != '\0'){
	    newstr = (char *) malloc(strlen(cur_user)+1);
    	    strncpy(newstr, cur_user, strlen(cur_user));
    	    newstr[strlen(cur_user)] = '\0';
    	    point_arr = (ignore_list *) malloc(sizeof( ignore_list ));
    	    point_arr->user_name = newstr;
    	    point_arr->next = NULL;
    	    *cur_next = point_arr;
    	    cur_next = &(point_arr->next);
	}
    }
    fclose(listfile);

    coop_tty = (long * )malloc(TERM_SIZE*sizeof(long));

    for (I=0; I < TERM_SIZE; I++ ){
	coop_tty[I] = 0;
    }
    
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void log_user_access(int cmd_flag){
	char buff[BUF_SIZE*5+1];

    if ( ((logadmins == 0)&&(cmd_flag == UT_ADMIN))||((logplugins == 0)&&(cmd_flag == UT_PLUGIN))){
	return;
    }
    snprintf(buff,BUF_SIZE*5,"Preparing");

    if (cmd_flag == UT_USER){
	snprintf(buff,BUF_SIZE*5,"%s user", buff);
    }
    if (cmd_flag == UT_ADMIN){
	snprintf(buff,BUF_SIZE*5,"%s admin", buff);
    }
    if (cmd_flag == UT_PLUGIN){
	snprintf(buff,BUF_SIZE*5,"%s plugin", buff);
    }
    snprintf(buff,BUF_SIZE*5,"%s statistic for user [%s][%s]. Time: [%s]-[",buff,user_name,gen_ipaddr,ctime(&start_t));
    snprintf(buff,BUF_SIZE*5,"%s%s].",buff,ctime(&end_t));
    log_info(buff);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Check valid terminal. Return 0 - allow, 1 - deny.*/

int check_tty(char * ut_line){
	str_array * str_pnt;
	char * sub_str;   

    str_pnt = calctty;
    while (str_pnt != NULL){
    	if( (sub_str = strchr(str_pnt->item, '*' )) != NULL ){
	    if (strncmp(ut_line, str_pnt->item, (sub_str-str_pnt->item-1 ) ) == 0){
                 return 0;
    	    }
	} else {    
	    if (strncmp(ut_line, str_pnt->item, UT_LINESIZE ) == 0){
                 return 0;
    	    }
	}
	str_pnt=str_pnt->next;
    } 
    return 1;
}