/* 
 *  stest.c - Test service activity. 
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include	"getstatd.h"

char * conf_path;
extern	char * optarg;
extern	int	opterr;

long timeout = 10;

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void alarm_timeout (int sig){
    exit(5);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int main( int argc, char *argv[] ){
	int			sockfd;
        struct hostent *hp;
	struct sockaddr_in	serv_addr;
	char			buff[BUF_SIZE*5+1];
	char	*		str_ptr;

    if ( (argc < 3)||(argc > 4) ){
	fprintf(stderr,"Usage: %s <host> <port> [timeout]\n",argv[0]);
	fprintf(stderr,"Return values:\n");
	fprintf(stderr,"\t\t0 - success.\n");
	fprintf(stderr,"\t\t1 - host not found.\n");
	fprintf(stderr,"\t\t2 - can't open stream socket.\n");
	fprintf(stderr,"\t\t3 - can't connect to server.\n");
	fprintf(stderr,"\t\t4 - error in command line.\n");
	fprintf(stderr,"\t\t5 - timeout.\n");
	return 4;
    }
    if ( argc == 4 ){
	timeout  = atoi(argv[3]);
    }
    set_signal(SIGALRM, alarm_timeout);
    alarm(timeout);
    bzero((char *) &serv_addr, sizeof(struct sockaddr_in));
    serv_addr.sin_family      = AF_INET;
    if ( (hp = gethostbyname(argv[1])) == NULL ){
	return 1;
    }
    bcopy(hp->h_addr,&serv_addr.sin_addr,hp->h_length);
    serv_addr.sin_port        = htons(atoi(argv[2]));

    if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0){
	return 2;
    }
    
    if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0){
	return 3;
    }

    while ( fgets(buff, BUF_SIZE*5, stdin) != NULL){
	writeline(sockfd, buff);    
    }
    while ( readline(sockfd,buff,BUF_SIZE*5) > 0){
	printf("%s",buff);
    }
    close(sockfd);
    return 0;
}
