/* 
 *  signal.c - Setting up the signal. 
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "getstatd.h"

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void set_signal(int sig_num, sig_func * func){
	struct sigaction	act;
    
    act.sa_handler = func;
    sigemptyset(&act.sa_mask);
//  sigaddset(&act.sa_mask, sig_num);
    act.sa_flags = 0;
    if (sig_num == SIGALRM) {
#ifdef	SA_INTERRUPT
	act.sa_flags |= SA_INTERRUPT;	/* SunOS */
#endif
    } else {
#ifdef	SA_RESTART
	act.sa_flags |= SA_RESTART;		/* SVR4, 44BSD */
#endif
    }
    if (sigaction(sig_num, &act, NULL) < 0){
	log_info("daemon aborting.");
	log_error("signal error.");
    }
}
