/* 
 *  sighandl.c - Set a signal handler.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "getstatd.h"

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void ignore_trace (int sig){
     signal(sig, ignore_trace);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void chld_trace (int sig){
    int i;

/*  
 * wait(&i);
 */
  while (waitpid ( -1, &i,  WNOHANG  ) > 0);
#ifndef	SA_RESTART
    set_signal (SIGCHLD, chld_trace);
#endif
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void kill_trace (int sig){
  log_info("Daemon terminated.");
  exit (1);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void alarm_trace (int sig){
/*    alarm (ALARM_TIME);*/
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void hup_trace (int sig){
  log_info ("Daemon restarting.");
  reload_config();
#ifndef	SA_RESTART
    set_signal (SIGCHLD, hup_trace);
#endif
}
