/* 
 *  pwdcheck.c - Identificate the user password and check his rights. 
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "getstatd.h"

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
 
int pwdcheck (int isauth){
	char * user_id;
	char * user;
	char * passwd;
	char cl_query[BUF_SIZE*10+1];
	char buff[BUF_SIZE+1];
	#define AUTH_SIZE 21 
	int dsize, flag = 0;

    while((dsize = readline(gen_socket,cl_query,BUF_SIZE*10)) > 2){
    	cl_query[dsize] = '\0';
	if ( strstr( cl_query, "Authorization: Basic ") != NULL){
	    flag = 1;
	    user_id = cl_query + AUTH_SIZE;
	    break;
        }
    }

    if ( (flag == 0)||(isauth != 0)){
	    get_auth();
    	    return -1;
    }

    mark_first_word(user_id);
    user = uudecode(user_id);
    if ( (passwd = strchr(user, ':')) == NULL){
    	    return -1;
    }
    passwd[0] = '\0';
    passwd++;
    
    
    flag = check_local_pwd(user, passwd);
    if (flag == -1) {
	flag = check_pop_pwd(user, passwd);
    }
    strncpy(user_name, user, BUF_SIZE);
    user_name[BUF_SIZE] = '\0';
    fill_null( user );
    fill_null( passwd );
    free (user);

    if (flag != 0){
	snprintf (buff, BUF_SIZE, "Identification error, wrong user [%s][%s]", user_name, gen_ipaddr);
	log_info(buff);
    }
    return flag;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int usercheck( char * username, int usertype ){
	FILE * listfile;
	char cur_user[BUF_SIZE+1];
	char buff[BUF_SIZE+1];
	char * str_ptr;

    switch ( usertype ){
	case UT_USER:
		    listfile = fopen(userlist, "r");
		    break;
	case UT_ADMIN:
		    listfile = fopen(adminlist, "r");
		    break;
	case UT_PLUGIN:
		    listfile = fopen(pluginlist, "r");
		    break;
	default:
		    log_info("Unrecognized user type.");
		    return -1;
		    break;    
    }

    if ( listfile == NULL) {
	log_info("Can't open list file.");
	return -1;
    }
    
    while ( fgets( cur_user, BUF_SIZE, listfile) != NULL ){

	str_ptr = strpbrk(cur_user, DILIMERS);

	if (str_ptr != NULL){
	    str_ptr[0] = '\0';
	}

	if (strcasecmp(cur_user, username ) == 0){
	    fclose(listfile);
	    return 0;
	}

	if (strncmp(cur_user,"*",1) == 0){
	    fclose(listfile);
	    return 0;
	}
    
    }

    snprintf (buff, BUF_SIZE, "User [%s][%s] not allowed for this operation.", user_name, gen_ipaddr);
    log_info(buff);
    fclose(listfile);
    return -1;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void get_auth(){

    prints( "HTTP/1.0 401 Unauthorithed\n");
    prints( "WWW-Authenticate: Basic realm=\"Authorithed user\"\n");
}
