/* 
 *  pwd_ident.c - Check user in local password file.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "getstatd.h"

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Identify user in local password file. return 1 - wrong, return 0 - success */

int check_local_pwd(char * user_name, char * user_passwd){
	FILE * pwdfile;
	char cur_user[BUF_SIZE+1];
	char buff[BUF_SIZE+1];
	char * str_ptr;
	char * pwd_ptr;

    if ( (pwdfile = fopen(pwdlist, "r")) == NULL) {
	log_info("Can't open password file.");
	return -1;
    }
    
    while ( fgets( cur_user, BUF_SIZE, pwdfile) != NULL ){

	str_ptr = strpbrk(cur_user, ":");

	if (str_ptr != NULL){
	    str_ptr[0] = '\0';
	    pwd_ptr = (++str_ptr);	
	    str_ptr = strpbrk(pwd_ptr, ":");
	    if (str_ptr != NULL){
		str_ptr[0] = '\0';
		if (strcmp( user_name , cur_user ) == 0){
		    if (pwdcrypt == 1){
			if ( strcmp( crypt( user_passwd , pwd_ptr ), pwd_ptr ) == 0){
			    fclose(pwdfile);
			    return 0;
			} else {
			    snprintf (buff, BUF_SIZE, "Password error for user [%s][%s].", user_name, gen_ipaddr);
			    log_info(buff);
			    fclose(pwdfile);
			    return 1;
			}
		    } else {
			if ( strcmp( user_passwd , pwd_ptr ) == 0){
			    fclose(pwdfile);
			    return 0;
			} else {
			    snprintf (buff, BUF_SIZE, "Password error for user [%s][%s].", user_name, gen_ipaddr);
			    log_info(buff);
			    fclose(pwdfile);
			    return 1;
			}
		    }
	    	}
	    }
	}
    }
    fclose(pwdfile);
    return -1;
}
