/* 
 *  proc_req.c - Process user query. 
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include	"getstatd.h"

int	gen_socket;
char    gen_ipaddr[BUF_SIZE+1];
time_t start_t, end_t;

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void proc_req(int socket, struct sockaddr_in	cli_addr){
          int dsize;
          char buff[BUF_SIZE*20+1];
          char item[BUF_SIZE+1];
	  char * tmp_str;
      
    gen_socket = socket;
    tmp_str = inet_ntoa(cli_addr.sin_addr);
    strncpy(gen_ipaddr, tmp_str, BUF_SIZE);
    gen_ipaddr[BUF_SIZE] = '\0';
    if (dsize = readline(socket, buff, BUF_SIZE*20)){
	buff[dsize] = '\0';

	if ( (strncasecmp(buff,"GET ", 4) == 0)&&
	     (get_query_item (buff,"/get_statistic", item, BUF_SIZE) == 0 )&&
	     (trans_query (&start_t, &end_t,buff) == 0)){
	    
	    prepare_lists();
	/* Get Statistic */

	    if ( get_query_item (buff,"automatic",item,BUF_SIZE) == 0 ){

            	    if (make_user_name(cli_addr) == NULL) {
            		get_file(socket, deny_identification);
                    	return;
		    }

		    if ( usercheck( user_name, UT_USER ) == 0){
			log_user_access(UT_USER);
			get_file (socket, user_index);
		    } else {
			get_file (socket, deny_right);
		    }
		    return;
	    }
	/* Password Identification */

	    if ( get_query_item (buff,"passwd",item,BUF_SIZE) == 0 ){

		    if (pwdcheck( 0 ) == 0){

			if ( usercheck( user_name, UT_USER ) == 0){
    			    log_user_access(UT_USER);
			    get_file (socket, user_index);
			} else {
			    pwdcheck( 1 );
			    get_file (socket, deny_right);
			}
		    } else {
			get_auth();
			get_file (socket, deny_passwd);
		    }
		    return;
	    }

	/* View plugins */

	    if ( get_query_item (buff,"plugin",item,BUF_SIZE) == 0 ){

		    if (pwdcheck( 0 ) == 0){

			if ( usercheck( user_name, UT_PLUGIN ) == 0){
			    log_user_access(UT_PLUGIN);
			    get_file (socket, plugin_index);
			} else {
			    pwdcheck( 1 );
			    get_file (socket, deny_right);
			}
		    } else {
			get_auth();
			get_file (socket, deny_passwd);
		    }
		    return;
	    }
	/* Line Statistic */

	    if ( get_query_item (buff,"line_statistic",item,BUF_SIZE) == 0 ){

		    if (pwdcheck( 0 ) == 0){

			if ( usercheck( user_name, UT_ADMIN ) == 0){
			    log_user_access(UT_ADMIN);
			    get_file (socket, admin_index);
			} else {
			    pwdcheck( 1 );
			    get_file (socket, deny_right);
			}
		    } else {
			get_auth();
			get_file (socket, deny_passwd);
		    }
		    return;
	    }
	
	    get_file (socket, index_path);
	} else {
	    get_file (socket, index_path);
	}
    }
}    

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int get_query_item ( char * query, char * item, char * result, int result_size){
		char * str_addr;
		int I;

    if ( (str_addr = strstr(query, item)) == NULL ){
        return -1;
    }
    if ( (str_addr = strchr(str_addr, '=')) == NULL ){
        return -1;
    }
    str_addr++; // Begin of item value.
    for (I=0; (str_addr[I] != '\0')&&(str_addr[I] != '&')&&(str_addr+I-query < result_size);I++){
        result[I]= str_addr[I];
    }
    result[I] = '\0';
	return 0;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void mark_first_word(char *item){
    	int I;

    for (I=0; item[I] != '\0';I++){
         if ( (item[I] == '%')||(item[I] == '+')||(item[I] == ' ')){
		    item[I] = '\0';
            return;
         }
    }
}

 /*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int trans_query (time_t *start_date, time_t *end_date, char * cmd){
	int s_year=0, s_month=0, s_day=0,e_year=0, e_month=0, e_day=0;
	struct tm start_tm; 
	struct tm end_tm; 
	char res[BUF_SIZE*10+1];



    if (get_query_item(cmd, "s_year", res, BUF_SIZE*10) != 0){
	return -1;
    }
    mark_first_word(res);
    s_year = atoi(res);

    if (get_query_item(cmd, "s_month", res, BUF_SIZE*10) != 0){
	return -1;
    }
    mark_first_word(res);
    s_month = atoi(res);

    if (get_query_item(cmd, "s_day", res, BUF_SIZE*10) != 0){
	return -1;
    }
    mark_first_word(res);
    s_day = atoi(res);

    if (get_query_item(cmd, "e_year", res, BUF_SIZE*10) != 0){
	return -1;
    }
    mark_first_word(res);
    e_year = atoi(res);

    if (get_query_item(cmd, "e_month", res, BUF_SIZE*10) != 0){
	return -1;
    }
    mark_first_word(res);
    e_month = atoi(res);

    if (get_query_item(cmd, "e_day", res, BUF_SIZE*10) != 0){
	return -1;
    }
    mark_first_word(res);
    e_day = atoi(res);


    start_tm.tm_sec = 0;
    start_tm.tm_min = 0;
    start_tm.tm_hour = 0;
    start_tm.tm_mday = s_day;
    start_tm.tm_mon = s_month-1;
    start_tm.tm_year = s_year-1900;

    end_tm.tm_sec = 0;
    end_tm.tm_min = 0;
    end_tm.tm_hour = 0;
    end_tm.tm_mday = e_day;
    end_tm.tm_mon = e_month-1;
    end_tm.tm_year = e_year-1900;
    *start_date = mktime(&start_tm);
    *end_date = mktime(&end_tm);
    return 0;         
}
