/* 
 *  print_stat.c - Prepare user statistic. 
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "getstatd.h"

long all_count, line_count, all_night;
user_list ** cur_next_user;
user_list *  all_userlist;
tty_list  ** cur_next_tty;
tty_list  *  all_ttylist;

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int list_line(struct utmp *p, time_t t, int what, time_t start_date, 
			    time_t end_date, char * user_name, int cmd_flag){

        char logintime[TIME_SIZE+1];
        char logouttime[TIME_SIZE+1];
        char length[TIME_SIZE+1];
        char buff[BUF_SIZE+1];
        time_t secs, tmp, from_night, end_night, tmp_night;
        int mins, hours, Flag, line_in_use;
	str_array * str_pnt;    	
	ignore_list * ignore_pnt;    	
	user_list * point_user;
	tty_list * point_tty;
	char	* newstr;

/* Check user name if generating current user statistic */
  if ((strncasecmp(p->ut_name, user_name, UT_NAMESIZE ) != 0)&&
                                     ( cmd_flag == CMD_USERSTAT)){ 
	return 0; 
  }

/* Check valid terminal */
    Flag = check_tty(p->ut_line);

/* Compare user name with ignorelist */
    ignore_pnt = ignore_userlist;
    while (ignore_pnt != NULL){
        if (strncasecmp(p->ut_name, ignore_pnt->user_name, UT_NAMESIZE) == 0){
             Flag = 1;
        }
	ignore_pnt=ignore_pnt->next;
    } 

  if (Flag) {
     return 0;
  }

/* Calculate times */

  tmp = (time_t) p->ut_time;
  strncpy(logintime, ctime(&tmp), TIME_SIZE);
  logintime[TIME_SIZE] = '\0';
  snprintf( logouttime, TIME_SIZE, "%s", ctime(&t));
  secs = t - p->ut_time;
  mins   = (secs / 60)%60;
  hours = (secs / 3600);
  snprintf(length, TIME_SIZE, "%02d:%02d", hours, mins);

/* Check login status */
  switch(what) {
	case R_DOWN:
	case R_NOW:
	case R_REBOOT:
	        return 0;	
	case R_CRASH:
        case R_NORMAL:
		break;
  }

  if ( (p->ut_time >= start_date) && ((p->ut_time <= end_date))){

        all_count += secs;

	tmp_night = nighttime*60*60*(secs/(60*60*24)+1);
	from_night = make_utc_time ( p->ut_time, nightfrom);
	end_night = from_night + nighttime*60*60;

	if ( p->ut_time > from_night) {
             tmp_night -= p->ut_time - from_night;
	}

	if ( t < end_night) {
             tmp_night -= end_night - t;
	}

	if ((p->ut_time >= end_night) || ( t <= from_night)) {
	    tmp_night = 0;
	}
	all_night += tmp_night;

	if ( cmd_flag == CMD_USERSTAT){
    	    if (line_count/2 == line_count/2.0){ 	
    		prints(NONEVENTR);
		prints("<TD>&nbsp;");
		//d11 Online time
        	snprintf(buff,TIME_SIZE,"%s (%ld)",length,secs/60);
  		prints(buff);        
		prints("</TD>");
		prints("<TD>&nbsp;");
    		//d12 Connect.
  		prints(p->ut_host);        
		prints("</TD>");
		prints("<TD>&nbsp;");
    		//d13 Link up, time (h:m)
  		prints(logintime);        
		prints("</TD>");
		prints("<TD>&nbsp;");
    		//d14 Link down, time (h:m)
  		prints(logouttime);        
		prints("</TD>");
		prints("</TR>");
		line_count++;
	    } else {
		prints(EVENTR);
		prints("<TD>&nbsp;");
    		//d11 Online time
        	snprintf(buff,TIME_SIZE,"%s (%ld)",length,secs/60);
  		prints(buff);        
		prints("</TD>");
		prints("<TD>&nbsp;");
    		//d12 Connect.
  		prints(p->ut_host);        
		prints("</TD>");
		prints("<TD>&nbsp;");
    		//d13 Link up, time (h:m)
  		prints(logintime);        
		prints("</TD>");
		prints("<TD>&nbsp;");
    		//d14 Link down, time (h:m)
  		prints(logouttime);        
		prints("</TD>");
	        prints("</TR>");
		line_count++;
	    }
	}

	if ( (cmd_flag == CMD_LASTSTAT) && (line_count < 600)){
		logintime[strlen(logintime)-1]='\0';
	    	snprintf(buff,BUF_SIZE,"%-3.3d, %-8.8s  %-6.6s   %s (%ld)\t%-5.5s\t%s - %s",line_count,p->ut_name,p->ut_line,length,secs/60,p->ut_host,logintime,logouttime);
  		prints(buff);        
		line_count++;
	}
	
	if ( (cmd_flag == CMD_ALLUSERSTAT) || (cmd_flag == CMD_LASTSTAT) || 
					    (cmd_flag == CMD_LINESTAT)){
	    Flag = 0;
	    point_user = all_userlist;
	    while (point_user != NULL){
    		if (strncasecmp(p->ut_name, point_user->user_name, UT_NAMESIZE) == 0){
                     Flag = 1;
		     (point_user->all_count)++;
		     point_user->all_time += secs;
		     point_user->all_night += tmp_night;
    		}
		point_user=point_user->next;
	    } 

	    if (Flag == 0){
		newstr = (char *) malloc(UT_NAMESIZE+1);
    		strncpy(newstr,p->ut_name,UT_NAMESIZE);
		newstr[UT_NAMESIZE] = '\0';
    		point_user = (user_list *) malloc(sizeof( user_list ));
    		point_user->user_name = newstr;
		point_user->all_count = 1;
		point_user->all_time = secs;
		point_user->all_night = tmp_night;
    		point_user->next = NULL;
    		*cur_next_user = point_user;
    		cur_next_user = &(point_user->next);
	    }
	}

	if ( (cmd_flag == CMD_LINESTAT)||(cmd_flag == CMD_LASTSTAT)||
					(cmd_flag == CMD_ALLUSERSTAT)){
	    point_tty = all_ttylist;
	    line_in_use =1;
	    Flag = 0;

	    while (point_tty != NULL){

    		if (strncmp(p->ut_line, point_tty->tty_name, UT_LINESIZE ) == 0){
		     Flag = 1;
		     (point_tty->all_count)++;
		     point_tty->all_time += secs;
		     point_tty->all_night += tmp_night;
		     point_tty->begin_time = p->ut_time;
		     point_tty->end_time = t;
    		}

		if ((point_tty->begin_time > p->ut_time)||(point_tty->end_time < t)){

		    if (( point_tty->begin_time < t) && ( point_tty->end_time > p->ut_time)) { 
    			line_in_use++;
		    }
		}
		point_tty=point_tty->next;
	    }
	    if (line_in_use-1 < TERM_SIZE){
		   coop_tty[line_in_use-1]++;
	    }
	    if (Flag == 0){
    		newstr = (char *) malloc(UT_LINESIZE+1);
    		strncpy(newstr, p->ut_line, UT_LINESIZE);
		newstr[UT_LINESIZE] = '\0';
    		point_tty = (tty_list *) malloc(sizeof( tty_list ));
    		point_tty->tty_name = newstr;
		point_tty->all_count = 0;
		point_tty->all_time = 0;
		point_tty->all_night = 0;
		point_tty->begin_time = 0;
		point_tty->end_time = 0;
    		point_tty->next = NULL;
    		*cur_next_tty = point_tty;
    		cur_next_tty = &(point_tty->next);
		str_pnt=str_pnt->next;
	    }
	    
	}
	
	 
  }
  return 0;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
 /* Portions from "last" */
 
int print_time_stat (time_t start_date, time_t end_date, char * user_name, int cmd_flag){
          FILE *fp;	
          struct utmp ut;
          utmp_list * utmplist = NULL;
          utmp_list *p;	
          utmp_list *next;
          time_t lastboot = 0; 
          time_t lastrch = 0;	
          time_t lastdown;
          time_t begintime;
          int whydown = 0;
          struct stat st;
          int quit = 0;
          int lastb = 0;
          int down;

    all_userlist = NULL;
    cur_next_user = &(all_userlist);
    all_ttylist = NULL;
    cur_next_tty = &(all_ttylist);
    all_count =0;
    all_night =0;
    line_count =0;

    if ((fp = fopen(wtmp_path, "r")) == NULL) {
	log_error ("Can't open wtmp file.");
    }
  

    if (fread(&ut, sizeof(struct utmp), 1, fp) == 1){
	begintime = ut.ut_time;

    } else {
  	fstat(fileno(fp), &st);
	begintime = st.st_ctime;
    }

    fseek(fp, -1L * sizeof(struct utmp), SEEK_END);

  /* Read struct after struct */
    while(fread(&ut, sizeof(struct utmp), 1, fp)) {

	if (lastb){
		quit = list_line(&ut, ut.ut_time, R_NORMAL,start_date,end_date,user_name, cmd_flag);
	} else {
	        down = 0;

	        if (strncmp(ut.ut_line, "~", 1) == 0) {
		/* Halt/reboot/shutdown etc */

		    if (strncmp(ut.ut_name, "shutdown", 8) == 0) {
			lastdown = lastrch = ut.ut_time;
			down = 1;
		    }

		    if (strncmp(ut.ut_name, "reboot", 6) == 0) {
			strncpy(ut.ut_line, "system boot", UT_LINESIZE);
			quit = list_line(&ut, lastdown, R_REBOOT, start_date, end_date, user_name, cmd_flag);
			lastdown = ut.ut_time;
			down = 1;
		    }

		    if (strncmp(ut.ut_name, "runlevel", 7) == 0) {
			down = 1;
			lastrch = ut.ut_time;
		    }

		    if (down) {
			lastboot = ut.ut_time;
			whydown = R_CRASH;

			/* Delete the list; it's meaningless now */
			for(p = utmplist; p; p = next) {
				next = p->next;
				free(p);
			}
			utmplist = NULL;
		    }

	        } else {
		/* Allright, is this a login or a logout? */

		if (ut.ut_name[0] != 0 && strcmp(ut.ut_name, "LOGIN")) {
			/* This is a login */
			/* Walk through list to see when logged out */

			for(p = utmplist; p; p = next) {
				next = p->next;

				if (strncmp(p->ut.ut_line, ut.ut_line, UT_LINESIZE) == 0){
					/* Show it */
					quit = list_line(&ut, p->ut.ut_time, R_NORMAL,start_date,end_date,user_name, cmd_flag);
					/* Delete it from the list */

					if (p->next){
					    p->next->prev = p->prev;
					}

					if (p->prev){
						p->prev->next = p->next;
					} else {
						utmplist = p->next;
					}
					free( p );
					break;
				}
			}
			/* Not found? Then crashed, down or still logged in */
			if (p == NULL)
				if (lastboot == 0){
					quit = list_line(&ut, time(NULL), R_NOW,start_date,end_date,user_name, cmd_flag);
				} else {
					quit = list_line(&ut, lastboot, whydown,start_date,end_date,user_name, cmd_flag);
				}
		}
		/* Get some memory */
		p = (utmp_list *) malloc(sizeof(utmp_list));
		/* Fill in structure */
		memcpy(&p->ut, &ut, sizeof(struct utmp));
		p->next  = utmplist;
		p->prev  = NULL;

		if (utmplist){
		    utmplist->prev = p;
		}
		utmplist = p;
	  }
      }
      /* Position the file pointer 2 structures back */
      if (fseek(fp, -2 * sizeof(struct utmp), SEEK_CUR) < 0){
          break;
      }	  
  }
  fclose(fp);
    
}
