/* 
 *  pop_ident.c - Check user by pop3 protocol.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "getstatd.h"

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int is_ok(char * str){

        if (strncmp(str, OK_ANS, OK_ANS_SIZE) != 0 ){
	return 1;
    }    
    return 0;
}    

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Identify user by pop3 protocol. return 1 - wrong, return 0 - success */

int check_pop_pwd(char * user_name, char * user_passwd){

	int			sockfd;
        struct hostent *hp;
	struct sockaddr_in	serv_addr;
	char			buff[BUF_SIZE*5+1];

    if (strncmp(host_auth,"*",1)== 0){
	return 1;
    }

    bzero((char *) &serv_addr, sizeof(struct sockaddr_in));
    serv_addr.sin_family      = AF_INET;
    if ( (hp = gethostbyname(host_auth)) == NULL ){
	log_info("POP3 host not found.");
	return 1;
    }
    bcopy(hp->h_addr,&serv_addr.sin_addr,hp->h_length);
    serv_addr.sin_port        = htons(pop3_port);

    if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0){
	log_info("can't open stream socket");
	return 1;
    }
    
    if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0){
	log_info("can't connect to pop3 server");
	return 1;
    }

    readline(sockfd ,buff, BUF_SIZE*5);
    if (is_ok(buff) != 0){
	close(sockfd);
	return 1;
    }

    snprintf(buff, BUF_SIZE*5, "%s %s\n",USER_QUERY, user_name);
    writeline(sockfd, buff);    

    readline(sockfd,buff,BUF_SIZE*5);
    if (is_ok(buff) != 0){
	close(sockfd);
	return 1;
    }

    snprintf(buff, BUF_SIZE*5, "%s %s\n",PASS_QUERY, user_passwd);
    writeline(sockfd, buff);    

    readline(sockfd,buff,BUF_SIZE*5);
    if (is_ok(buff) != 0){
	close(sockfd);
	return 1;
    }

    snprintf(buff, BUF_SIZE*5, "%s\n",QUIT_QUERY);
    writeline(sockfd, buff);    

    close(sockfd);
    return 0;
}
