/* 
 *  loadform.c - Parse html form with includes.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include	"getstatd.h"

#define TMP_BUFF_SIZE 4096	

form_item includes[] = {{"@WHO@",inc_who},
			{"@LINE@",inc_line},
			{"@LAST@",inc_last},
			{"@USERS@",inc_users},
			{"@PLUGINHEADER1@",inc_pluginheader1},
			{"@PLUGIN1@",inc_plugin1},
			{"@PLUGINHEADER2@",inc_pluginheader2},
			{"@PLUGIN2@",inc_plugin2},
			{"@PLUGINHEADER3@",inc_pluginheader3},
			{"@PLUGIN3@",inc_plugin3},
			{"@PLUGINHEADER4@",inc_pluginheader4},
			{"@PLUGIN4@",inc_plugin4},
			{"@STATUSER@",inc_statususer},
			{"@FROMDATE@",inc_fromdate},
			{"@TODATA@",inc_todate},
			{"@STATISTIC@",inc_statistic},
			{"@SUMHOUR@",inc_sumhour},
			{"@SUMMIN@",inc_summin},
			{"@SUMDAYHOUR@",inc_sumdayhour},
			{"@SUMDAYMIN@",inc_sumdaymin},
			{"@SUMNIGHTHOUR@",inc_sumnighthour},
			{"@SUMNIGHTMIN@",inc_sumnightmin},
			{"@VERSION@",inc_version},
			{"@REFRESH@",inc_refresh},
			{0,0}};


/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
int perform_includes(int socket, char * buff ){
	int I, J, Flag = 0, ExitFlag = 0;
	char	* tmp_buff  = (char *) malloc(TMP_BUFF_SIZE+1);
	char	* old_buff;

    strncpy(tmp_buff, buff, TMP_BUFF_SIZE);
    tmp_buff[TMP_BUFF_SIZE] = '\0';
    old_buff = tmp_buff;
    J = 0;
    do {
        for (;( tmp_buff[J] != '\0') && ( tmp_buff[J] != '@'); J++){;}

	if ( tmp_buff[J] != '\0'){
    
    	    for ( I = 0; includes[I].name != 0; I++){

		    if (strncasecmp(includes[I].name,tmp_buff+J,strlen(includes[I].name)) == 0){
			tmp_buff[J] = '\0';
		        writeline(socket,tmp_buff);    	    	        
			(includes[I].parser)();
			
			tmp_buff += strlen(includes[I].name)+J;
			J = 0;
			Flag++;
			break;
		    }
    	    }
	} else {
	    ExitFlag = 1;
	}
    } while (ExitFlag == 0);

    if (Flag) {
        writeline(socket,tmp_buff);    	    	        
	free (old_buff);
	return 0;
    } else {
        free (old_buff);
	return 1;
    }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void get_file (int socket, char * path_name){
       char	* str_buff  = (char *) malloc(TMP_BUFF_SIZE+1);
       FILE * index_file;

  if ((index_file = fopen(path_name,"r")) == NULL) {
	log_error("can't open reguested html form.\n");
  }
  snprintf(str_buff, TMP_BUFF_SIZE, HTTP_ANSWER);
  writeline(socket, str_buff);

  while ( fgets( str_buff, TMP_BUFF_SIZE, index_file) != NULL ){

      if ( perform_includes(socket, str_buff ) != 0) {
          writeline(socket, str_buff);
      }
  }
  fclose(index_file);    
  free(str_buff);
}
