/* 
 *  loadcfg.c - Processing configuration items.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include	"getstatd.h"
#include 	"cfg_mgr2.h"

long	low_serv_port = 0;
long serv_port = DEFAULT_PORT;
str_array * ipallow;
int n_ipallow = 0;
str_array * calctty;
int n_calctty = 0;
char * wtmp_path = NULL;
char * utmp_path = NULL;
char * index_path = NULL;
char * deny_path = NULL;
long pop3_port = POP3_PORT;
char * host_auth = NULL;
int nighttime = DEFAULT_NIGHTTIME;
int nightfrom = DEFAULT_NIGHTFROM;
char * deny_identification = NULL;
char * deny_passwd = NULL;
char * deny_right = NULL;
char * autoauthdir = NULL;
char * userlist = NULL;
char * adminlist = NULL;
char * pluginlist = NULL;
char * ignoreusers = NULL;
char * pwdlist = NULL;
char * plugin1 = NULL;
char * plugin2 = NULL;
char * plugin3 = NULL;
char * plugin4 = NULL;
char * pluginheader1 = NULL;
char * pluginheader2 = NULL;
char * pluginheader3 = NULL;
char * pluginheader4 = NULL;
char * plugin_index = NULL;
char * user_index = NULL;
char * admin_index = NULL;
int    pwdcrypt=1;
int    logadmins=0;
int    logplugins=0;
long	refresh = REFRESH_FORM;

cfg_item items[] = {{"port","",0,&serv_port,0,p_uint},
                    {"calctty","",0,&calctty,&n_calctty,p_arrstring},
                    {"ipallow","",0,&ipallow,&n_ipallow,p_arrstring},
                    {"wtmp","",0,&wtmp_path,0,p_string},
                    {"utmp","",0,&utmp_path,0,p_string},
                    {"index","",0,&index_path,0,p_string},
                    {"deny","",0,&deny_path,0,p_string},
                    {"portauth","",0,&pop3_port,0,p_uint},
                    {"nighttime","",0,&nighttime,0,p_int},
                    {"nightfrom","",0,&nightfrom,0,p_int},
                    {"hostauth","",0,&host_auth,0,p_string},
                    {"deny_identification","",0,&deny_identification,0,p_string},
                    {"deny_passwd","",0,&deny_passwd,0,p_string},
                    {"deny_right","",0,&deny_right,0,p_string},
                    {"autoauthdir","",0,&autoauthdir,0,p_string},
                    {"userlist","",0,&userlist,0,p_string},
                    {"adminlist","",0,&adminlist,0,p_string},
                    {"pluginlist","",0,&pluginlist,0,p_string},
                    {"pwdlist","",0,&pwdlist,0,p_string},
                    {"pwdcrypt","",0,&pwdcrypt,0,p_bool},
                    {"logadmins","",0,&logadmins,0,p_bool},
                    {"logplugins","",0,&logplugins,0,p_bool},
                    {"plugin1","",0,&plugin1,0,p_string},
                    {"plugin2","",0,&plugin2,0,p_string},
                    {"plugin3","",0,&plugin3,0,p_string},
                    {"plugin4","",0,&plugin4,0,p_string},
                    {"pluginheader1","",0,&pluginheader1,0,p_string},
                    {"pluginheader2","",0,&pluginheader2,0,p_string},
                    {"pluginheader3","",0,&pluginheader3,0,p_string},
                    {"pluginheader4","",0,&pluginheader4,0,p_string},
                    {"plugin_index","",0,&plugin_index,0,p_string},
                    {"user_index","",0,&user_index,0,p_string},
                    {"admin_index","",0,&admin_index,0,p_string},
                    {"ignoreusers","",0,&ignoreusers,0,p_string},
                    {"refresh","",0,&refresh,0,p_long},
		    {0,0,0,0,0}};

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void check_open(char * file_name){
    char buff[BUF_SIZE+1];
    
  if ((file_name == NULL) || ((access(file_name, R_OK)) != 0)) {
	snprintf (buff, BUF_SIZE, "can't open file [%s]. Check configuration file.",file_name);
	log_error(buff);
  }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void load_config ( void ){
        struct hostent *hp;

    cfg_item_process( conf_path, items);

    if (n_ipallow == 0){
        log_error("No 'ipallow' rules found.");
    }

    if (n_calctty == 0){
        log_error("No 'calctty' rules found.");
    }

    if (wtmp_path == NULL){
#ifdef HAVE_PATHS_H
        wtmp_path=_PATH_WTMP;
#else
        wtmp_path=_DEF_WTMP;
#endif
    }

    if (utmp_path == NULL){
#ifdef HAVE_PATHS_H
        utmp_path=_PATH_UTMP;
#else
        utmp_path=_DEF_UTMP;
#endif
    }

    if (host_auth == NULL){
        utmp_path=_HOST_AUTH;
    }

    if (autoauthdir == NULL){
	log_error("'autoauthdir' not set.");
    }

    if (strncmp(host_auth,"*",1) != 0){
	if ( (hp = gethostbyname(host_auth)) == NULL ){
	    log_error("'hostauth' not resolved, host not found.");
	}
    }
    check_open( index_path );
    check_open( utmp_path );
    check_open( wtmp_path );
    check_open( deny_identification );
    check_open( deny_passwd );
    check_open( deny_right );
    check_open( userlist );
    check_open( adminlist );
    check_open( pluginlist );
    check_open( pwdlist );
    check_open( plugin_index );
    check_open( user_index );
    check_open( admin_index );
    check_open( ignoreusers );
    if (low_serv_port != 0){
	serv_port = low_serv_port;
    }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void reload_config( void ){
	str_array * str_pnt;
	str_array * str_pnt_temp;

    if (low_serv_port == 0){
	serv_port = DEFAULT_PORT;
    } else {
	serv_port = low_serv_port;
    }
    pop3_port = POP3_PORT;
    nighttime = DEFAULT_NIGHTTIME;
    nightfrom = DEFAULT_NIGHTFROM;
    refresh   = REFRESH_FORM;
    pwdcrypt  = 1;
    logadmins = 0;
    logplugins= 0;
    
    str_pnt = ipallow;
    while (str_pnt != NULL){
	free (str_pnt->item);
	str_pnt_temp=str_pnt->next;
	free (str_pnt);
	str_pnt = str_pnt_temp;
    } 

    str_pnt = calctty;
    while (str_pnt != NULL){
	free (str_pnt->item);
	str_pnt_temp=str_pnt->next;
	free (str_pnt);
	str_pnt = str_pnt_temp;
    } 

    n_ipallow=0;
    n_calctty=0;

    free(wtmp_path);
    free(ignoreusers);
    free(utmp_path);
    free(index_path);
    free(deny_path);
    free(host_auth);
    free(deny_identification);
    free(deny_passwd);
    free(deny_right);
    free(autoauthdir);
    free(userlist);
    free(adminlist);
    free(pluginlist);
    free(pwdlist);
    if ( plugin1 != NULL ) { free(plugin1);}
    if ( plugin2 != NULL ) { free(plugin2);}
    if ( plugin3 != NULL ) { free(plugin3);}
    if ( plugin4 != NULL ) { free(plugin4);}
    if ( pluginheader1 != NULL ) { free(pluginheader1);}
    if ( pluginheader2 != NULL ) { free(pluginheader2);}
    if ( pluginheader3 != NULL ) { free(pluginheader3);}
    if ( pluginheader4 != NULL ) { free(pluginheader4);}
    free(plugin_index);
    free(user_index);
    free(admin_index);

    plugin1 = NULL;
    plugin2 = NULL;
    plugin3 = NULL;
    plugin4 = NULL;
    pluginheader1 = NULL;
    pluginheader2 = NULL;
    pluginheader3 = NULL;
    pluginheader4 = NULL;
    plugin_index = NULL;
    user_index = NULL;
    admin_index = NULL;
    wtmp_path = NULL;
    utmp_path = NULL;
    index_path = NULL;
    deny_path = NULL;
    host_auth = NULL;
    deny_identification = NULL;
    deny_passwd = NULL;
    deny_right = NULL;
    autoauthdir = NULL;
    userlist = NULL;
    pwdlist = NULL;
    adminlist = NULL;
    ignoreusers = NULL;

    load_config();
}