/* 
 *  includes.c - Actions for includes.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "getstatd.h"

char cur_ip[BUF_SIZE+1];
char user_name[BUF_SIZE+1];
int	speed_flag = 0;
/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print "who is online" statistic */

void inc_who ( void ){

    prints("LOGIN      TTY    (IP ADDRESS) SUM TIME\tLOGIN TIME\t\t     CURRENT TIME\n");
    who_is_on();
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

/* Print terminal statistic */

void inc_line ( void ){
	tty_list * point_tty;
	char buff[BUF_SIZE+1];
	long	cnt_tmp = 0;
	int I, tty_num=0;

    prints(" TTY       ALL\t\t   DAY\t\t   NIGHT\t\tCONNECTS\n");
    if ( speed_flag == 0){
	speed_flag++;
	print_time_stat(start_t, end_t,user_name, CMD_LINESTAT);
    }
    point_tty = all_ttylist;
    while (point_tty != NULL){
		snprintf(buff,BUF_SIZE,"%-6.6s     %-2.2d:%-2.2d (%-5.1ld)   %-2.2d:%-2.2d (%-5.1ld)   %-2.2d:%-2.2d (%-5.1ld)\t%ld\n",
			 point_tty->tty_name,
			 (point_tty->all_time/ 3600),(point_tty->all_time/60) % 60,
			 point_tty->all_time/60,
			 ((point_tty->all_time-point_tty->all_night)/ 3600),
			 ((point_tty->all_time-point_tty->all_night)/60) % 60,
			 (point_tty->all_time-point_tty->all_night)/60,
			 (point_tty->all_night/ 3600),(point_tty->all_night/60) % 60,
			 point_tty->all_night/60,
			 point_tty->all_count);
		prints(buff);        
		tty_num++;
		point_tty=point_tty->next;
    }
    
    prints("\nACTIVE TTYS -  PERCENTS\n");        

    for (I=0; I < tty_num; I++ ){
	cnt_tmp +=coop_tty[I];
    }
    
    for (I=0; I < tty_num; I++ ){
	snprintf(buff,BUF_SIZE,"%-5d       -  %.2f\n",I+1,(coop_tty[I]*100.0)/cnt_tmp);
    	prints(buff);        
    }

}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print last users statistic */

void inc_last ( void ){
    prints("NUM, LOGIN     TTY      ONLINE\t  \tSPEED\tLOGIN TIME\t\tLOGOUT TIME\n");
	speed_flag++;
	print_time_stat(start_t,end_t,user_name, CMD_LASTSTAT);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print general users statistic */

void inc_users ( void ){
	user_list * point_user;
	char buff[BUF_SIZE+1];

    prints("USER    ONLINE: ALL\t\tDAY\t\tNIGHT\t\tCONNECTS\n");
    if ( speed_flag == 0){
	speed_flag++;
	print_time_stat(start_t, end_t, user_name, CMD_ALLUSERSTAT);
    }
    point_user = all_userlist;
	while (point_user != NULL){
		snprintf(buff,BUF_SIZE,"%-8.8s        %-2.2d:%-2.2d (%-5.1ld)\t%-2.2d:%-2.2d (%-5.1ld)\t%-2.2d:%-2.2d (%-5.1ld)\t%ld\n",
			 point_user->user_name,
			 (point_user->all_time/ 3600),(point_user->all_time/60) % 60,
			 point_user->all_time/60,
			 ((point_user->all_time-point_user->all_night)/ 3600),
			 ((point_user->all_time-point_user->all_night)/60) % 60,
			 (point_user->all_time-point_user->all_night)/60,
			 (point_user->all_night/ 3600),(point_user->all_night/60) % 60,
			 point_user->all_night/60,
			 point_user->all_count);
		prints(buff);        
		point_user=point_user->next;
	}
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print plugin header */

void inc_pluginheader1 ( void ){

    if ( pluginheader1 !=  NULL ){
	prints(pluginheader1);
    }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Execute plugin */

void inc_plugin1 ( void ){
    system(plugin1);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print plugin header */

void inc_pluginheader2 ( void ){
    
    if ( pluginheader2 !=  NULL ){
	prints(pluginheader2);
    }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Execute plugin */

void inc_plugin2 ( void ){
    system(plugin2);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print plugin header */

void inc_pluginheader3 ( void ){

    if ( pluginheader3 !=  NULL ){
	prints(pluginheader3);
    }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Execute plugin */

void inc_plugin3 ( void ){
    system(plugin3);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print plugin header */

void inc_pluginheader4 ( void ){

    if ( pluginheader4 !=  NULL ){
	prints(pluginheader4);
    }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Execute plugin */

void inc_plugin4 ( void ){
    system(plugin4);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print current user name */

void inc_statususer ( void ){
    prints(user_name);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print "from" date*/

void inc_fromdate ( void ){
    prints(ctime(&start_t));
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print "to" date*/

void inc_todate ( void ){
    prints(ctime(&end_t));
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print current user statistic */

void inc_statistic ( void ){
     print_time_stat(start_t,end_t,user_name, CMD_USERSTAT);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void inc_sumhour ( void ){
	char buff[BUF_SIZE+1];
    snprintf(buff,BUF_SIZE,"%-2.2d:%-2.2d",(all_count / 3600),(all_count/60) % 60);
    prints(buff);        
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void inc_summin ( void ){
	char buff[BUF_SIZE+1];
    snprintf(buff,BUF_SIZE,"%ld",all_count/60);
    prints(buff);        
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void inc_sumdayhour ( void ){
	char buff[BUF_SIZE+1];
    snprintf(buff,BUF_SIZE,"%-2.2d:%-2.2d",((all_count - all_night)/ 3600),((all_count- all_night)/60) % 60);
    prints(buff);        
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void inc_sumdaymin ( void ){
	char buff[BUF_SIZE+1];
    snprintf(buff,BUF_SIZE,"%ld",(all_count-all_night)/60);
    prints(buff);        
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void inc_sumnighthour ( void ){
	char buff[BUF_SIZE+1];
    snprintf(buff,BUF_SIZE,"%-2.2d:%-2.2d",(all_night / 3600),(all_night/60) % 60);
    prints(buff);        
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void inc_sumnightmin ( void ){
	char buff[BUF_SIZE+1];
    snprintf(buff,BUF_SIZE,"%ld",all_night/60);
    prints(buff);        
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print getstatd version */

void inc_version ( void ){
    prints(GETSTATD_VER);
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
/* Print refresh time */

void inc_refresh ( void ){
	char buff[BUF_SIZE+1];
    snprintf(buff,BUF_SIZE,"%ld", refresh);
    prints(buff);        
}
