/* 
 *  gs_adduser.c - create new crypted (DES or MD5) user accaunt.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include "config.h"
#include "getstatd.h"
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>

#define PASSWD_FILE 	"./getstatd.passwd"
#define BUF_SIZE 	128
extern	char * optarg;
extern	int	opterr;

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright 1989 - 1992, Julianne Frances Haugh
 * All rights reserved.
 */

int i64c(int i)
{
	if (i <= 0)
		return ('.');

	if (i == 1)
		return ('/');

	if (i >= 2 && i < 12)
		return ('0' - 2 + i);

	if (i >= 12 && i < 38)
		return ('A' - 12 + i);

	if (i >= 38 && i < 63)
		return ('a' - 38 + i);

	return ('z');
}
/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright 1989 - 1992, Julianne Frances Haugh
 * All rights reserved.
 */

char * l64a(long l)
{
	static	char	buf[8];
	int	i = 0;

	if (l < 0L)
		return ((char *) 0);

	do {
		buf[i++] = i64c ((int) (l % 64));
		buf[i] = '\0';
	} while (l /= 64L, l > 0 && i < 6);

	return (buf);
}
/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */
void read_stdin(char * text, char ** input){
	   char tmp_buff[BUF_SIZE+1];
    
    printf("%s", text);
    fgets(tmp_buff, BUF_SIZE, stdin);
    tmp_buff[strlen(tmp_buff)-1] = '\0';
    *input = (char *)malloc(strlen(tmp_buff)+1);
    strcpy(*input, tmp_buff);
}
/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int main( int argc, char *argv[] ){

	   int I;
	   int opt;
	   char * user_name = NULL;
	   char * user_pwd = NULL;
	   char * pwd_name = NULL;
	   char buff[BUF_SIZE+1];
	   char tmp_buff[BUF_SIZE+1];
	   int md5_flag = 0;
	   int allow_flag = 1;
#ifdef  HAVE_GETTIMEOFDAY
	   struct timeval tv;
#else
	   time_t tm;
#endif
	   char salt[BUF_SIZE+1];
           FILE * passwd_file;

    opterr = 0;
    while ((opt = getopt(argc, argv, "hmvf:u:p:")) != EOF){
	switch(opt){
	    case 'v':
		    printf("gs_adduser for getstatd %s. Copyright (c) Maxim Chirkov\n\n", GETSTATD_VER);
		    return 1;
	    case 'm':
		    md5_flag = 1;
		    break;
	    case 'f':
	    	    if (optarg != 0) {
			pwd_name = (char *) malloc(strlen(optarg)+1);
	        	if (pwd_name == NULL){
			    return 3;
			}
			strcpy(pwd_name, optarg);
			break;
	    	    }
	    case 'u':
	    	    if (optarg != 0) {
			user_name = (char *) malloc(strlen(optarg)+1);
	        	if (user_name == NULL){
			    return 3;
			}
			strcpy(user_name, optarg);
			break;
	    	    }
	    case 'p':
	    	    if (optarg != 0) {
			user_pwd = (char *) malloc(strlen(optarg)+1);
	        	if (user_pwd == NULL){
			    return 3;
			}
			strcpy(user_pwd, optarg);
			break;
	    	    }
	    case '?':
	    	    fprintf(stderr, "Invalid option or missing parameter.\n\n");
	    case 'h':
		    printf("Usage: %s [-f pwd_file] [-u username] [-p password] [-m] [-h]\n\n", argv[0]);
                    printf("-h        - Print  a  usage message on standard output and exit.\n");
		    printf("-m        - Use MD5 encryption (default DES).\n");
		    printf("-u user   - User name.\n");
		    printf("-p passwd - User password.\n");
		    printf("-f file   - Location of password file.(default ./getstatd.passwd)\n\n");
		    return 2;
	}
    
    }

    if ( pwd_name == NULL){
	pwd_name = PASSWD_FILE;
    }

    do {
	if ( user_name == NULL){
	    read_stdin("Username to add: ",&user_name);
	}

	if (( passwd_file = fopen(pwd_name, "r")) != NULL){
	    while ( ( !feof(passwd_file) ) && ( allow_flag != 0 )){
	          fgets(buff, BUF_SIZE, passwd_file);
	          strncpy(tmp_buff, strtok( buff, ":"), BUF_SIZE);
	          allow_flag = strcmp(tmp_buff, user_name);
	    }
	    fclose(passwd_file);
	}
	if( allow_flag == 0 ){
	      printf("That name is in use, choose another.\n");
	      free (user_name);
	      user_name	= NULL;
	}
    } while( allow_flag == 0);
    
    allow_flag = 1;
    while( allow_flag != 0){
	if ( user_pwd == NULL){
    	    read_stdin("Password : ",&user_pwd);
	}
        if (strcmp(user_pwd,"") != 0){
	    allow_flag = 0;
	} else {
	    free (user_pwd);
	    user_pwd  = NULL;
	}
    }

    salt[0] = '\0';
    if ( md5_flag == 1) {
	strcpy(salt, "$1$");  /* magic for the new MD5 crypt() */
    }

#ifdef  HAVE_GETTIMEOFDAY
    gettimeofday(&tv, (struct timezone *) 0);
    strncat(salt, l64a(tv.tv_usec), BUF_SIZE);
    strncat(salt, l64a(tv.tv_sec + getpid() + clock()), BUF_SIZE);
#else
    time(&tm);
    strncat(salt, l64a(tm), BUF_SIZE);
    strncat(salt, l64a(tm + getpid() + clock()), BUF_SIZE);
#endif

    if (strlen(salt) > 3 + 8){
	salt[11] = '\0';
    }

    if ( (passwd_file=fopen(pwd_name, "a")) == NULL){
	printf ("Can't open passwd file: %s\n",pwd_name);
    }
    fprintf(passwd_file,"%s:%s:::::\n",user_name,crypt(user_pwd, salt));
    fclose(passwd_file);
    printf("Done.\n");
    
}
  


