/* 
 *  getstatd - User statistic visualization daemon.
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#ifndef __GETSTAT__
#define __GETSTAT__

#include "config.h"
#include "cfg_mgr2.h"

#ifdef HAVE_UNISTD_H
    #include <unistd.h>
#endif

#ifdef HAVE_FCNTL_H
    #include <fcntl.h>
#endif

#ifdef HAVE_LIMITS_H
    #include <limits.h>
#endif

#ifdef HAVE_PATHS_H
    #include <paths.h>
#endif

#ifdef HAVE_SYSLOG_H
    #include <syslog.h>
#endif

#ifdef HAVE_STDARG_H
    #include <stdarg.h>
#else
    #ifdef HAVE_VARARGS_H
	#include <varargs.h>
    #endif
#endif

#ifdef HAVE_LOCALE_H
    #include <locale.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <utmp.h>
#include <signal.h>
#include <string.h>

/* #include <netinet/in.h> */
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

/*
#include <net/if.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
*/

#ifndef EOF
    #define EOF (-1)
#endif
#ifndef NULL
    #if !defined(__cplusplus) || defined(__GNUC__)
	#define NULL ((void*)0)
    #else
	#define NULL (0)
    #endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Types.
 */

typedef void (*form_parser)(void);


typedef	void	sig_func(int);	


typedef struct _FORM_ITEM_ {
  char * name;
  form_parser  parser;
} form_item;


typedef struct _USER_LIST_ {
    char	* user_name;
    long	all_count;
    long	all_time;
    long	all_night;
    struct _USER_LIST_ * next;
} user_list;


typedef struct _TTY_LIST_ {
    char	* tty_name;
    long	all_count;
    long	all_time;
    long	all_night;
    time_t	begin_time;
    time_t	end_time;
    struct _TTY_LIST_ * next;
} tty_list;


typedef struct _IGNORE_LIST_ {
    char	* user_name;
    struct _IGNORE_LIST_ * next;
} ignore_list;


typedef struct _UTMP_LIST_ {
  struct utmp ut;
  struct _UTMP_LIST_ *next;
  struct _UTMP_LIST_ *prev;
} utmp_list;

/*
 *  Definitions.
 */

/* Base defaults */

    #define DAEMON_UID		65534
    #define EVENTR		"<TR BGCOLOR=\"#EDBE82\">"
    #define NONEVENTR		"<TR BGCOLOR=\"#FFCC99\">"
    #define ROOT_HTTP_PORT	80
    #define REFRESH_FORM	99999
/* Addition parameters */
    
    #define BUF_SIZE		128
    #define TIME_SIZE 		64
    #define TERM_SIZE 		128

#ifndef UT_LINESIZE
    #define UT_LINESIZE		8
#endif

#ifndef UT_NAMESIZE
    #define UT_NAMESIZE		8
#endif

    #define _HOST_AUTH		"localhost"
    #define POP3_PORT		110
    #define DEFAULT_PORT	1080
    #define DEFAULT_NIGHTTIME   7
    #define DEFAULT_NIGHTFROM   0
    #define _DEF_WTMP		"/etc/wtmp"
    #define _DEF_UTMP		"/etc/utmp"

    #define OK_ANS 		"+OK"
    #define OK_ANS_SIZE 	3
    #define USER_QUERY		"USER"
    #define PASS_QUERY		"PASS"
    #define QUIT_QUERY		"QUIT"
    #define HTTP_ANSWER		"HTTP/1.0 200 OK\nContent-type: text/html\n\n"
    #define DILIMERS 		", \t\n\r:;/\\#"
    #define ALARM_TIME 		30

    #define UT_USER 		1 /* Current user statistic */
    #define UT_ADMIN 		2 /* Admin statistic */
    #define UT_PLUGIN 		3 /* Plugin statistic */

    #define CMD_ZERO		0 /* Null operation */
    #define CMD_USERSTAT	1 /* Perform current user statistic */
    #define CMD_LASTSTAT	2 /* Perform last users statistic */
    #define CMD_LINESTAT	3 /* Perform line statistic */
    #define CMD_ALLUSERSTAT	4 /* Perform all users statistic */

    #define R_CRASH		1 /* No logout record, system boot in between */
    #define R_DOWN		2 /* System brought down in decent way */
    #define R_NORMAL		3 /* Normal */
    #define R_NOW		4 /* Still logged in */
    #define R_REBOOT		5 /* Reboot record. */

/*
 *  Global variables.
 */

extern char 		* conf_path;
extern long 		serv_port;
extern long 		low_serv_port;
extern str_array 	* ipallow;
extern int 		n_ipallow;
extern str_array	* calctty;
extern int 		n_calctty;
extern char 		* wtmp_path;
extern char 		* utmp_path;
extern char 		* index_path;
extern char 		* deny_path;
extern char 		* host_auth;
extern int		gen_socket;
extern long		pop3_port;
extern char 		* deny_identification;
extern char 		* deny_passwd;
extern char 		* deny_right;
extern char 		* userlist;
extern char 		* adminlist;
extern char 		* pluginlist;
extern char 		* ignoreusers;
extern char 		* pwdlist;
extern int 		pwdcrypt;
extern int    		logadmins;
extern int    		logplugins;
extern int 		nighttime;
extern int 		nightfrom;
extern char 		* autoauthdir;
extern char 		* plugin1;
extern char 		* plugin2;
extern char 		* plugin3;
extern char		* plugin4;
extern char 		* pluginheader1;
extern char 		* pluginheader2;
extern char 		* pluginheader3;
extern char 		* pluginheader4;
extern char 		* plugin_index;
extern char 		* user_index;
extern char 		* admin_index;
extern long		refresh;

extern time_t 		start_t;
extern time_t 		end_t;
extern long		all_count;
extern long		all_night;
extern long 		all_count;
extern long 		line_count;
extern ignore_list 	* ignore_userlist;
extern user_list 	* all_userlist;
extern tty_list		* all_ttylist;
extern long 		* coop_tty;
extern char 		user_name[BUF_SIZE+1];
extern char 		cur_ip[BUF_SIZE+1];
extern char 		gen_ipaddr[BUF_SIZE+1];


/* Useful functions */

extern int readline(int fd, char *ptr, int maxlen);
extern int writeline(int fd, char *ptr);
extern void prints( char *ptr);
extern void log_info(char *str);
extern void log_error(char *str);
extern char * uudecode( char *bufcoded);
extern void fill_null( char * str);
extern void mark_first_word(char *item);
extern time_t make_utc_time (time_t user_time, int night_time);
extern void log_user_access(int cmd_flag);
extern int check_tty(char * ut_line);


/* Signals */
extern void ignore_trace (int sig);
extern void kill_trace (int sig);
extern void alarm_trace (int sig);
extern void chld_trace (int sig);
extern void hup_trace (int sig);
extern void set_signal(int sig_num, sig_func * func);


/* Identification */
extern char * get_ip_user(char *ip_name);
extern char * make_user_name (struct sockaddr_in cli_addr);
extern char * get_tty_user(char *tty_name,char * user_name);
extern int pwdcheck (int isauth);
extern void get_auth();


/* Process query */
extern void prog_req(int socket,struct sockaddr_in	cli_addr);
extern int trans_query (time_t *start_date, time_t *end_date, char * cmd);
extern int get_query_item ( char * query, char * item, char * result, int result_size);


/* Statistic generation */
extern int print_time_stat(time_t start_date, time_t end_date, char * user_name, int cmd_flag);
extern void prepare_lists(void);


/* Process configuration items */
extern void load_config ( void );
extern void reload_config ( void );


/* HTML includes */
extern void get_file (int socket, char * path_name);
extern void inc_who ( void );
extern void inc_line ( void );
extern void inc_last ( void );
extern void inc_users ( void );
extern void inc_pluginheader1 ( void );
extern void inc_plugin1 ( void );
extern void inc_pluginheader2 ( void );
extern void inc_plugin2 ( void );
extern void inc_pluginheader3 ( void );
extern void inc_plugin3 ( void );
extern void inc_pluginheader4 ( void );
extern void inc_plugin4 ( void );
extern void inc_statususer ( void );
extern void inc_fromdate ( void );
extern void inc_todate ( void );
extern void inc_statistic ( void );
extern void inc_sumhour ( void );
extern void inc_summin ( void );
extern void inc_sumdayhour ( void );
extern void inc_sumdaymin ( void );
extern void inc_sumnighthour ( void );
extern void inc_sumnightmin ( void );
extern void inc_version ( void );
extern void inc_refresh ( void );

#ifdef __cplusplus
}
#endif
#endif