/* 
 *  getstatd.c - Main source module. 
 *
 *  Copyright (c) 1998  Maxim Chirkov <mc@skyway.ru>  
 */

#include	"getstatd.h"

char * conf_path = NULL;
extern	char * optarg;
extern	int	opterr;
/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int main( int argc, char *argv[] ){

	   int sockfd, newsockfd, clilen, childpid, I;
	   struct sockaddr_in	cli_addr, serv_addr;
           pid_t pid;
	   int opt;
	   long nobody_uid = DAEMON_UID;
	   int sock_opt=1;

/*
 * Parsing command line.
 */
    opterr = 0;
    while ((opt = getopt(argc, argv, "hf:vp:")) != EOF){
	switch(opt){
	    case 'v':
		    printf("getstatd %s. Copyright (c) Maxim Chirkov\n\n", GETSTATD_VER);
		    return 1;
	    case 'p':
	    	    if (optarg != 0) {
#ifdef HAVE_STRTOL
		    errno = 0;
		     low_serv_port = strtol (optarg, (char **) NULL, 0);
		    if (errno){
                         return 3;
		    }
#else
		    if (sscanf(optarg, "%u", &low_serv_port) == EOF){
    	                 return 3;
		    }
#endif
			break;
	    	    }
	    case 'f':
	    	    if (optarg != 0) {
			conf_path = (char *) malloc(strlen(optarg)+1);
	        	if (conf_path == NULL){
			    return 3;
			}
			strcpy(conf_path, optarg);
			break;
	    	    }
	    case '?':
	    	    fprintf(stderr, "Invalid option or missing parameter.\n\n");
	    case 'h':
		    printf("Usage: %s [-f config] [-p port] [-v] [-h]\n\n", argv[0]);
                    printf("-h        - Print  a  usage message on standard output and exit.\n");
		    printf("-v        - Print version information on standard  output and exit.\n");
		    printf("-p port   - Bind to specifed port [1-65534].\n");
		    printf("-f config - Use an alternate config file.\n\n");
		    return 2;
	}
    
    }

/*
 * Binding to low range port.
 */

    if ( low_serv_port != 0 ){
       if( geteuid() != 0){
	    log_error("Can't bind. Must be root.");
       }

       if ( (sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0){
	    log_error("can't open stream socket.");
       }
#ifdef HAVE_SETSOCKOPT
       setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &sock_opt, sizeof(sock_opt));
 #ifdef TCP_NODELAY
       sock_opt = 1;
       setsockopt(sockfd, IPPROTO_TCP, TCP_NODELAY, (char*)&sock_opt, sizeof(sock_opt));
 #endif
       sock_opt = 1;
       setsockopt(sockfd, SOL_SOCKET,SO_KEEPALIVE,(char *)&sock_opt,sizeof(sock_opt));
#endif

       bzero((char *) &serv_addr, sizeof(serv_addr));
       serv_addr.sin_family      = AF_INET;
       serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
       serv_addr.sin_port        = htons(low_serv_port);

       if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0){
	    log_error("can't bind local address.");
       }
    }

/*
 * Changing daemon uid if root. 
 */

   if( !geteuid() && setuid(nobody_uid) == -1){
    	log_error("Can't change uid.");
   }

/*
 * Parsing config file.
 */
    if (conf_path == NULL){
	conf_path = CONF_PATH;
    } 

    load_config();

/*
 * Starting the daemon. 
 */

    log_info("getstatd started...");

#ifdef HAVE_SETLOCALE

    setlocale(LC_ALL, "");
#endif

   if( (pid = fork()) < 0){
   	log_info("getstatd daemon aborting.");
   	log_error("couldn't fork.");
   } else {
   	if ( pid != 0 ){
 	      _exit(0);
   	}
   }

#ifndef FD_SETSIZE
    #ifdef __FD_SETSIZE
	#define FD_SETSIZE __FD_SETSIZE
    #else
	#define FD_SETSIZE 1024
    #endif
#endif

    for(I = 0; I < FD_SETSIZE; I++){

	if ( low_serv_port == 0 ){
    	    close(I);
	} else {
	    if (sockfd != I){
        	close(I);
	    }
	}
    }

    if (setsid() == -1){
   	log_error("couldn't setsid.");
    }
    chdir("/");
    umask(0);

/* 
 * Setting up signals.
 */
/*
    for (I= 1; I < NSIG; ++I){
         signal(I, ignore_trace);
    }
*/
    set_signal (SIGINT, kill_trace);
    set_signal (SIGQUIT, kill_trace);
    set_signal (SIGTERM, kill_trace);
    set_signal (SIGHUP, hup_trace);
    set_signal (SIGALRM, alarm_trace);
    set_signal (SIGCHLD, chld_trace);

/*
 * Setting alarm.
 */

/*    alarm ( ALARM_TIME ); // Not use in this version. */

/* 
 * Looping. 
 */

    if ( low_serv_port == 0 ){
       if ( (sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0){
	    log_error("can't open stream socket.");
       }

#ifdef HAVE_SETSOCKOPT
       setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &sock_opt, sizeof(sock_opt));
 #ifdef TCP_NODELAY
       sock_opt = 1;
       setsockopt(sockfd, IPPROTO_TCP, TCP_NODELAY, (char*)&sock_opt, sizeof(sock_opt));
 #endif
       sock_opt = 1;
       setsockopt(sockfd, SOL_SOCKET,SO_KEEPALIVE,(char *)&sock_opt,sizeof(sock_opt));
#endif

       bzero((char *) &serv_addr, sizeof(serv_addr));
       serv_addr.sin_family      = AF_INET;
       serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
       serv_addr.sin_port        = htons(serv_port);

       if (bind(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0){
	    log_error("can't bind local address.");
       }
    }

   if (listen(sockfd, 5) < 0){
	log_error("listen error.");
   }

   while (1) {
	clilen = sizeof(cli_addr);
        if ((newsockfd = accept(sockfd, (struct sockaddr *) &cli_addr,&clilen)) < 0){
		log_error("accept error.");
        }
	if ( (childpid = fork()) < 0){
		log_error("fork error.");
        } else if (childpid == 0) {
	        close(sockfd);

	/* Processing user request. */
                dup2(newsockfd,1);
                dup2(newsockfd,2);
		proc_req( newsockfd, cli_addr);
                close(newsockfd);
                _exit(0);
	}
	close(newsockfd);
   }
}
