/* 
 *  cfg_mgr2.h - Config parser header file.
 *
 *  Copyright (c) 1995-1998  Maxim Chirkov <mc@skyway.ru>  
 */


#ifndef __CFG_MGR2__
#define __CFG_MGR2__

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Defaults.
 */
#define STRBUFSIZE 	4096
#define E_FILENOTFOUND 	13
#define E_NOTCMD 	14
#define E_GOOD 		0
#define E_TYPE 		15
#define E_OVERFLOW 	16
#define D_SUBITEM 	"(){}"
#define D_BLOCK   	"[]"
#define D_SPACE   	" \t\n\r="
#define D_DILIMER 	", \t\n\r"
#define D_COMMENT 	";#"
#define D_HEX     	"0x"
#define D_STRING  	"\""
#define D_CHAR    	"'"
#define D_CMD     	"{}"
#define D_CMD_AND 	"&"
#define D_CMD_OR  	"|"
#define D_IGNORE  	"\"'\t\r\n{} "
#define D_SKIP  	"\"'\t\r\n, "

/*
 * Integers array.
 */
typedef struct _INT_ARRAY_ {
  int     item;
  struct _INT_ARRAY_ * next;
} int_array;

/*
 * Unsigned integers array.
 */
typedef struct _UINT_ARRAY_ {
  unsigned int     item;
  struct _UINT_ARRAY_ * next;
} uint_array;

/*
 * longs array.
 */
typedef struct _LONG_ARRAY_ {
  long     item;
  struct _LONG_ARRAY_ * next;
} long_array;

/*
 * Unsigned longs array.
 */
typedef struct _ULONG_ARRAY_ {
  unsigned long     item;
  struct _ULONG_ARRAY_ * next;
} ulong_array;

/*
 * Floats array.
 */
typedef struct _FLOAT_ARRAY_ {
  double     item;
  struct _FLOAT_ARRAY_ * next;
} float_array;

/*
 * String array.
 */
typedef struct _STR_ARRAY_ {
  char *     item;
  struct _STR_ARRAY_ * next;
} str_array;


/*
 * Default parser procedures.
 */

extern int p_char      (char * input, char * output, char * command,int * num);
extern int p_int       (char * input, int * output, char * command,int * num);
extern int p_uint      (char * input, unsigned int * output, char * command,int * num);
extern int p_long      (char * input, long * output, char * command,int * num);
extern int p_ulong     (char * input, unsigned long * output, char * command,int * num);
extern int p_double     (char * input, double * output, char * command,int * num);
extern int p_string    (char * input, char ** output, char * command,int * num);
extern int p_bool      (char * input, int * output, char * command,int * num);
extern int p_sub       (char * input, void * output, char * command,int * num);
extern int p_arrchar   (char * input, char ** output, char * command,int * num);
extern int p_arrint    (char * input, int_array ** output, char * command,int * num);
extern int p_arruint   (char * input, uint_array ** output, char * command,int * num);
extern int p_arrlong   (char * input, long_array ** output, char * command,int * num);
extern int p_arrulong  (char * input, ulong_array ** output, char * command,int * num);
extern int p_arrfloat  (char * input, float_array ** output, char * command,int * num);
extern int p_arrstring (char * input, str_array ** output, char * command,int * num);
extern int p_arrbool   (char * input, int ** output, char * command,int * num);

/*
 * Parser procedure definition. Last procedure in the parser array must be zero.
 */

typedef int (*cfg_parser)();

/*
 * Items definition. Last item in the item array must be zero.
 */

typedef struct _CFG_ITEM_ {
  char * name;
  char * command;
  int    flag;
  void * variable;
  int  * num;
  cfg_parser  parser;
} cfg_item;

/*
 * Block of items definition. Last block in the block array must be zero.
 */

typedef struct _CFG_BLOCK_ {
  char *     name;
  cfg_item * items;
} cfg_block;


extern int cfg_item_process ( char * config_name, cfg_item * items);
extern int cfg_block_process ( char * config_name, cfg_block * blocks);

#ifdef __cplusplus
};
#endif

#endif
