/* 
 *  cfg_mgr2.c - Config parser source code.
 *
 *  Copyright (c) 1995-1998  Maxim Chirkov <mc@skyway.ru>  
 */


#include "cfg_mgr2.h"
#include "getstatd.h"

int cur_line = 0;

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int check_char (char src_char, char * char_array){

    if ((src_char != '\0')&&(char_array[0] != '\0')){
	if (strchr( char_array, src_char) == NULL){
	    return 0;
	} else {
	    return 1;
	}
    } else {
	    return 0;
    }
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_char (char * input, char * output, char * command, int * num){

   if (input[0] == '\0'){
       return E_NOTCMD;
   }
   if (strlen(input) != 1){
      return E_TYPE;
   }
   *output = input[0];
   return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_int (char * input, int * output, char * command, int * num){
         char *tail;

    if (input[0] == '\0'){
        return E_NOTCMD;
    }
#ifdef HAVE_STRTOL
    errno = 0;
    *output = (int) strtol (input, &tail, 0);
    if (errno){
         return E_OVERFLOW;
    }
#else
    if (sscanf(input,"%d", output) == EOF){
         return E_OVERFLOW;
    }
#endif
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_uint (char * input, unsigned int * output, char * command, int * num){
         char *tail;

    if (input[0] == '\0'){
        return E_NOTCMD;
    }
#ifdef HAVE_STRTOUL
    errno = 0;
    *output = (unsigned int) strtoul (input, &tail, 0);
    if (errno){
         return E_OVERFLOW;
    }
#else
    if (sscanf(input,"%u", output) == EOF){
         return E_OVERFLOW;
    }
#endif
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_long (char * input, long * output, char * command, int * num){
         char *tail;

    if (input[0] == '\0'){
        return E_NOTCMD;
    }
#ifdef HAVE_STRTOL
    errno = 0;
    *output = strtol (input, &tail, 0);
    if (errno){
         return E_OVERFLOW;
    }
#else
    if (sscanf(input,"%ld", output) == EOF){
         return E_OVERFLOW;
    }
#endif
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_ulong (char * input, unsigned long * output, char * command, int * num){
         char *tail;

    if (input[0] == '\0'){
        return E_NOTCMD;
    }
#ifdef HAVE_STRTOUL
    errno = 0;
    *output = strtoul (input, &tail, 0);
    if (errno){
         return E_OVERFLOW;
    }
#else
    if (sscanf(input,"%lu", output) == EOF){
         return E_OVERFLOW;
    }
#endif
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_double (char * input, double * output, char * command, int * num){
         char *tail;

    if (input[0] == '\0'){
        return E_NOTCMD;
    }
#ifdef HAVE_STRTOD
    errno = 0;
    *output = strtod (input, &tail);
    if (errno){
         return E_OVERFLOW;
    }
#else
    if (sscanf(input,"%f", output) == EOF){
         return E_OVERFLOW;
    }
#endif
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_string (char * input, char ** output, char * command, int * num){

    if (input[0] == '\0'){
        return E_NOTCMD;
    }
    *output = (char *) malloc( strlen(input)+1 );
    strncpy( *output, input, strlen(input));
    (*output)[strlen(input)] = '\0';
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_bool (char * input, int * output, char * command, int * num){

     if (input[0] == '\0'){
         return E_NOTCMD;
     }
   if (strlen(input) != 1){
      if (strcasecmp(input,"TRUE") == 0){
          *output = 1;
      } else if (strcasecmp(input,"FALSE") == 0){
          *output = 0;
      } else {
          return E_TYPE;
      }
      return E_GOOD;
   }
   *output = input[0];
   if ((*output != 0)&&(*output != 1)){
      return E_TYPE;
   }
   return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_sub (char * input, void * output, char * command,int * num){
    /* Not supported yet*/
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_arrchar   (char * input, char ** output, char * command,int * num){
    /* Not supported yet*/
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_arrint (char * input, int_array ** output, char * command, int * num){
        char *tail;
        int_array * point_arr;
        int_array ** cur_next;
        int next;

     if (input[0] == '\0'){
         return E_NOTCMD;
     }
     *output = NULL;
     cur_next = &(*output);
     *num = 0;
     while (1) {
         while (((ispunct ( *input ))||isspace(*input))&&(*input != '-')){
            input++;
         }
         if (*input == 0){
            break;
         }
#ifdef HAVE_STRTOL
         errno = 0;
         next = (int) strtol (input, &tail, 0);
         if (errno){
             return E_OVERFLOW;
         } else {
#else
	 if (sscanf(input,"%d", &next) == EOF){
             return E_OVERFLOW;
	 } else {
#endif
	 
           (*num)++;
            point_arr = (int_array *) malloc(sizeof( int_array ));
            point_arr->item = next;
            point_arr->next = NULL;
            *cur_next = point_arr;
            cur_next = &(point_arr->next);
         }
         input = tail;
    }
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_arruint (char * input, uint_array ** output, char * command, int * num){
        char *tail;
        uint_array * point_arr;
        uint_array ** cur_next;
        int next;

     if (input[0] == '\0'){
         return E_NOTCMD;
     }
     *output = NULL;
     cur_next = &(*output);
     *num = 0;
     while (1) {
         while (((ispunct ( *input ))||isspace(*input))&&(*input != '-')){
            input++;
         }
         if (*input == 0){
            break;
         }
#ifdef HAVE_STRTOUL
         errno = 0;
         next = (unsigned int) strtoul (input, &tail, 0);
         if (errno){
             return E_OVERFLOW;
         } else {
#else
	 if (sscanf(input,"%u", &next) == EOF){
             return E_OVERFLOW;
	 } else {
#endif
	 
           (*num)++;
            point_arr = (uint_array *) malloc(sizeof( uint_array ));
            point_arr->item = next;
            point_arr->next = NULL;
            *cur_next = point_arr;
            cur_next = &(point_arr->next);
         }
         input = tail;
    }
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_arrlong (char * input, long_array ** output, char * command, int * num){
        char *tail;
        long_array * point_arr;
        long_array ** cur_next;
        int next;

     if (input[0] == '\0'){
         return E_NOTCMD;
     }
      *output = NULL;
     cur_next = &(*output);
     *num = 0;
     while (1) {
         while (((ispunct ( *input ))||isspace(*input))&&(*input != '-')){
            input++;
         }
         if (*input == 0){
            break;
         }
#ifdef HAVE_STRTOL
         errno = 0;
         next =  strtol (input, &tail, 0);
         if (errno){
             return E_OVERFLOW;
         } else {
#else
	 if (sscanf(input,"%ld", &next) == EOF){
             return E_OVERFLOW;
	 } else {
#endif
	 
            (*num)++;
            point_arr = (long_array *) malloc(sizeof( long_array ));
            point_arr->item = next;
            point_arr->next = NULL;
            *cur_next = point_arr;
            cur_next = &(point_arr->next);
         }
         input = tail;
    }
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_arrulong (char * input, ulong_array ** output, char * command, int * num){
        char *tail;
        ulong_array * point_arr;
        ulong_array ** cur_next;
        int next;

     if (input[0] == '\0'){
         return E_NOTCMD;
     }
      *output = NULL;
     cur_next = &(*output);
     *num = 0;
     while (input != 0) {
         while (((ispunct ( *input ))||isspace(*input))&&(*input != '-')){
            input++;
         }
#ifdef HAVE_STRTOUL
         errno = 0;
         next =  strtoul (input, &tail, 0);
         if (errno){
             return E_OVERFLOW;
         } else {
#else
	 if (sscanf(input,"%lu", &next) == EOF){
             return E_OVERFLOW;
	 } else {
#endif
	 
            (*num)++;
            point_arr = (ulong_array *) malloc(sizeof( ulong_array ));
            point_arr->item = next;
            point_arr->next = NULL;
            *cur_next = point_arr;
            cur_next = &(point_arr->next);
         }
         input = tail;
    }
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_arrfloat (char * input, float_array ** output, char * command, int * num){
        char *tail;
        float_array * point_arr;
        float_array ** cur_next;
        double next;

     if (input[0] == '\0'){
         return E_NOTCMD;
     }
      *output = NULL;
     cur_next = &(*output);
     *num = 0;
     while (1) {
         while ( !check_char( *input, D_SKIP )){
            input++;
         }
         if (*input == 0){
            break;
         }
#ifdef HAVE_STRTOD
         errno = 0;
         next = strtod (input, &tail);
         if (errno){
             return E_OVERFLOW;
         } else {
#else
	 if (sscanf(input,"%f", &next) == EOF){
             return E_OVERFLOW;
	 } else {
#endif
	 
	 
           (*num)++;
            point_arr = (float_array *) malloc(sizeof( float_array ));
            point_arr->item = next;
            point_arr->next = NULL;
            *cur_next = point_arr;
            cur_next = &(point_arr->next);
         }
         input = tail;
    }
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_arrstring (char * input, str_array ** output, char * command,int * num){
         char * tok;
         str_array * point_arr;
         str_array ** cur_next;
         char * newstr;

     if (input[0] == '\0'){
         return E_NOTCMD;
     }
    *num = 0;
    *output = NULL;
    cur_next = &(*output);
    if ((tok = strtok(input,D_DILIMER))== NULL){
        return E_GOOD;
    }
   
    do {

        newstr = (char *) malloc(strlen(tok)+1);
        strncpy(newstr, tok, strlen(tok));
        newstr[strlen(tok)] = '\0';
        (*num)++;
        point_arr = (str_array *) malloc(sizeof( str_array ));
        point_arr->item = newstr;
        point_arr->next = NULL;
        *cur_next = point_arr;
        cur_next = &(point_arr->next);

    } while ((tok=strtok(NULL,D_DILIMER)) != NULL);

    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int p_arrbool (char * input, int ** output, char * command,int * num){
    /* Not implemented yet */
    return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

char * str_strip(char * str){
       int I, J = 0;
       
   for ( I = 0; (str[I] != '\0')&&(check_char(str[I], D_IGNORE)); I++){;}
   for (; str[I] != '\0';I++){
       str[J++] = str[I];
   }
   for (J--; (J >= 0)&&(check_char(str[J], D_IGNORE));J--){;}
   str[J+1] = '\0';
   return str;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int set_variable ( char * cmd, char * arg, cfg_item * items){
        int I;

   for ( I = 0; items[I].name != 0; I++){
      if (strcasecmp(items[I].name, cmd) == 0){
            if ( (items[I].parser)(str_strip(arg),items[I].variable,
   		                   items[I].command, items[I].num) != E_GOOD){

                  openlog("getstatd", LOG_PID | LOG_CONS, LOG_DAEMON);
                  syslog(LOG_ERR, "[config parser] Unknown data type in line %d",cur_line);
                  closelog();	
                  printf("[config parser] Unknown data type in line %d\n",cur_line);
                  exit(1); 	    
	    
	    }
            break;
      }
   }
   if ( items[I].name == 0 ){

          openlog("getstatd", LOG_PID | LOG_CONS, LOG_DAEMON);
          syslog(LOG_ERR, "[config parser] Command not recognized in line %d, ignored",cur_line);
          closelog();	
          printf("[config parser] Command not recognized in line %d, ignored\n",cur_line);
          exit(1); 	    
          return E_NOTCMD;
   }
   return E_GOOD;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

void del_comment (char * str_buff){
       int I, str_flag=0;

    for(I=0; (str_buff[I] != '\0') && ((!check_char(str_buff[I], D_COMMENT))||
	                                                     (str_flag)); I++){

      if ( check_char(str_buff[I], D_STRING) || check_char(str_buff[I], D_CHAR)){
         if (str_flag){
             str_flag = 0;
         } else {
             str_flag = 1;
         }
      }
    }
    str_buff[I] = '\0';
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int read_str (char ** buffer, FILE * cfg_file ){
       int block_flag = 0;
       int size = 0;
       char * str_buff = (char *) malloc(STRBUFSIZE+1);

  do {

     if( fgets( str_buff, STRBUFSIZE, cfg_file) == NULL ){
        return -1;
    }
    cur_line++;
 
     del_comment(str_buff);
     if (check_char('{',str_buff)){
       block_flag = 1;
     }
     if (check_char('}',str_buff)){
       block_flag = 0;
     }
     if ( size+strlen(str_buff) > STRBUFSIZE ){

            openlog("getstatd", LOG_PID | LOG_CONS, LOG_DAEMON);
            syslog(LOG_ERR, "[config parser] Command block is too long [%d].",cur_line);
            closelog();
            printf("[config parser] Command block is too long [%d].\n",cur_line);
            exit(1);
     }
     strncpy(*buffer+size, str_buff, strlen(str_buff));
     (*buffer)[size+strlen(str_buff)] = '\0';
     size += strlen(str_buff);

  } while ( block_flag == 1);
  free(str_buff);
  return 0;
}

/*
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

int cfg_item_process ( char * config_name, cfg_item * items){
       char * str_buff = (char *)malloc(STRBUFSIZE+1);
       char * cmd_addr;
       char * arg_addr;
       FILE * cfg_file;
       int  I, result;
       int brck_flag, str_flag, space_flag, arg_flag, gen_flag;

  if ((cfg_file = fopen(config_name,"r")) == NULL) {

      openlog("getstatd", LOG_PID | LOG_CONS, LOG_DAEMON);
      syslog(LOG_ERR, "[config parser] Can't open config file [%s].",config_name);
      closelog();	
      printf("[config parser] Can't open config file [%s].\n",config_name);
      exit(1); 	    
      return E_FILENOTFOUND;
  }

  while( read_str( &str_buff, cfg_file) == 0 ){

    brck_flag = str_flag = arg_flag =  0;
    space_flag = gen_flag = 1;
    cmd_addr = arg_addr = NULL;
    for(I=0; (str_buff[I] != '\0'); I++){

      if ((!check_char(str_buff[I], D_SPACE)) && gen_flag){
         if (space_flag){
             cmd_addr = (char *)(str_buff+I);
             space_flag = 0;
         }
         if (arg_flag){
             arg_addr = (char *)(str_buff+I);
             gen_flag = 0;
         }
      } else {
         if ((!space_flag) && (gen_flag)){
            str_buff[I] = '\0';
            arg_flag = 1;
         }
      }
    }
    str_buff[I] = '\0';
    if (cmd_addr != NULL) {
	 if ( arg_addr == NULL){
	     arg_addr = (char *)(str_buff+I);
	 }
         if ((result = set_variable(cmd_addr, arg_addr, items)) != E_GOOD ){
/*             return result; */
         }
    }
  }
  free(str_buff);
  fclose(cfg_file);
  return E_GOOD;
}

