/*
*
* APS - Advanced Packet Sniffer
*
*  Copyright (C) 1999 Christian Schulte
*
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*
*/




#include <aps_types.h>
#include <lansi.h>

extern unsigned char buf[];
extern unsigned int n_byte;
extern void pnum_pname(unsigned int p1,unsigned int p2,char *s);
extern s_aps_cntr *p_cnt;
extern unsigned int G_OPTS;
extern unsigned char COLORS;

void udp_info(void);

void udp_info(void)
{
char pname[50];
unsigned int send_port,recv_port,length,crc;


 send_port=(buf[n_byte])  +(buf[n_byte+1]<<8);  // get 'em
 recv_port=(buf[n_byte+2])+(buf[n_byte+3]<<8);
 length   =(buf[n_byte+4])+(buf[n_byte+5]<<8);
 crc      =(buf[n_byte+6])+(buf[n_byte+7]<<8);
 
 
 pnum_pname(send_port,recv_port,(char *) &pname);
 if (!(G_OPTS&0x02))
 {
   if (COLORS) CYAN;
   printf("PORT:%-5d->%-5d (%s) LENGTH: 0x%-4x   CRC: 0x%-4x\n",
   send_port,recv_port,pname,length,crc);
 }

 p_cnt->udp_ip++;  // for the statistics
 
 n_byte+=8;
}


