/*
*
* APS - Advanced Packet Sniffer
*
*  Copyright (C) 1999 Christian Schulte
*
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*
*/

#include <config.h>


// s_aps_cnt is used to sum up the counters for different packet formats 
// exactly this struct with the size of STRCTSZE_CNTR is set as a shared-memory segment
// for read write access (should be root because aps normaly does not start with user permissions !)

// NUM_CNTRS is the numbers of values from type int in s_aps_cntr !!
#define NUM_CNTRS 34

// STRCTSZE_CNTR will contain the size of the struct (is used for unions)
#define STRCTSZE_CNTR NUM_CNTRS*SIZEOF_INT



#undef TRUE
#define TRUE 1
#undef FALSE
#define FALSE 0



typedef struct
{
 unsigned int udp_ip;       // not splitted down until now
 unsigned int tcp_ip;       // not splitted down until now
 unsigned int icmp_ip_echo_req;  // ICMP ECHO
 unsigned int icmp_ip_echo_rep;
 unsigned int icmp_ip_unre_net;  // ICMP UNREACHEBLE
 unsigned int icmp_ip_unre_host;
 unsigned int icmp_ip_unre_proto;
 unsigned int icmp_ip_unre_port;
 unsigned int icmp_ip_unre_frag_need;
 unsigned int icmp_ip_unre_src_route;
 unsigned int icmp_ip_unre_unknown;  // Nr,10 (from 0)
 unsigned int icmp_ip_source_quench;
 unsigned int icmp_ip_redir_tonet;// ICMP REDIRECT
 unsigned int icmp_ip_redir_tohost;
 unsigned int icmp_ip_redir_tos_net;
 unsigned int icmp_ip_redir_tos_host;
 unsigned int icmp_ip_redir_unknown;
 unsigned int icmp_ip_exc_time_limit;  // ICMP ???
 unsigned int icmp_ip_dtgr_param_prob;  // Nr,18 (from 0)
 unsigned int icmp_ip_time_req;
 unsigned int icmp_ip_time_rep;
 unsigned int icmp_ip_info_req;
 unsigned int icmp_ip_info_rep;
 unsigned int icmp_ip_addr_mask_req;
 unsigned int icmp_ip_addr_mask_rep;
 unsigned int icmp_ip_unknown;      // UNKNOWN ICMP-TYPES
 unsigned int rarp_req;  // Nr,26 (from 0)
 unsigned int rarp_rep;
 unsigned int arp_req;
 unsigned int arp_rep;
 unsigned int smb;
 unsigned int loop;
 unsigned int ipx;  // Nr,16 (from 0)
 unsigned int unknown;
}s_aps_cntr;
   


typedef union  
{
 unsigned int N[NUM_CNTRS];
}a_un_cntrs;








