/*
*
* APS - Advanced Packet Sniffer
*
*  Copyright (C) 1999 Christian Schulte
*
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*
*/


#include <lansi.h>
#include <aps_types.h>

extern unsigned char buf[];
extern int n_byte;
extern s_aps_cntr *p_cnt;
extern unsigned int PRINT_MODE,G_OPTS;
extern unsigned char COLORS;

void get_icmp_redirect_code (char *s,char code);
void get_icmp_unreachable_code (char *s,char code);
void icmp_info (void);




void get_icmp_redirect_code (char *s,char code)
{
 switch(code)
 {
  case(0):strcpy(s,"redirect datagrams to NETWORK");p_cnt->icmp_ip_redir_tonet++;break;
  case(1):strcpy(s,"redirect datagrams to HOST");p_cnt->icmp_ip_redir_tohost++;break;
  case(2):strcpy(s,"redirect datagrams to TOS on NETWORK");p_cnt->icmp_ip_redir_tos_net++;break;
  case(3):strcpy(s,"redirect datagrams to TOS on HOST");p_cnt->icmp_ip_redir_tos_host++;break;
  default:sprintf(s,"unknown redirect:%d",code);p_cnt->icmp_ip_redir_unknown++;break;
}}



void get_icmp_unreachable_code (char *s,char code)
{
 switch(code)
 {
  case(0):strcpy(s,"Network unreachable");p_cnt->icmp_ip_unre_net++; break;
  case(1):strcpy(s,"Host unreachable");p_cnt->icmp_ip_unre_host++; break;
  case(2):strcpy(s,"Protocol unreachable");p_cnt->icmp_ip_unre_proto++; break;
  case(3):strcpy(s,"Port unreachable");p_cnt->icmp_ip_unre_port++; break;
  case(4):strcpy(s,"Fragmentation needed but DF set");p_cnt->icmp_ip_unre_frag_need++; break;
  case(5):strcpy(s,"Source route failed");p_cnt->icmp_ip_unre_src_route++; break;
  default:sprintf(s,"ICMP-unreachable %d(unknown)",code);p_cnt->icmp_ip_unre_unknown++; break;
}}




void icmp_info (void)
{   // print the icmp packet...

char code[50];

 if ( (!(PRINT_MODE&0x80)) && (!(G_OPTS&0x02)) )
 switch(buf[n_byte])  // switch out the type-field
 {
  case(0): if (COLORS) if (COLORS) BLUE;
  	   printf("%-30s CODE:0x%x CRC:0x%x SIG:0x%x NUM:0x%x\n",
           "echo reply",buf[n_byte+1],(buf[n_byte+2])+(buf[n_byte+3]<<8),
     	   (buf[n_byte+4])+(buf[n_byte+5]<<8),(buf[n_byte+6])+(buf[n_byte+7]<<8));
           n_byte+=8;
	   p_cnt->icmp_ip_echo_rep++;  // for the statistics
           break;         // echo reply 
  case(3): if (COLORS) BLUE;
  	   get_icmp_unreachable_code((char *) &code,buf[n_byte+1]);
           printf("%-30s\n",code);
           n_byte+=2;
           break;
  case(4): if (COLORS) BLUE;
  	   printf("%-30s","source quench (slow down tx)\n");
           n_byte+=1;
	   p_cnt->icmp_ip_source_quench++;   // for the statistics
           break;
  case(5): if (COLORS) BLUE;
  	   get_icmp_redirect_code ((char *) &code,buf[n_byte+1]);
           printf("%-30s %-30s","redirect (route change)\n",code);
           n_byte+=2;                     
           break;
  case(8): if (COLORS) BLUE;
  	   printf("%-30s CODE:0x%x CRC:0x%x SIG:0x%x NUM:0x%x\n",
           "echo request",buf[n_byte+1],(buf[n_byte+2])+(buf[n_byte+3]<<8),
     	   (buf[n_byte+4])+(buf[n_byte+5]<<8),(buf[n_byte+6])+(buf[n_byte+7]<<8));
           n_byte+=8;
	   p_cnt->icmp_ip_echo_req++;   // for the statistics
           break;         // echo request
  case(11):if (COLORS) BLUE;
  	   printf("%-30s","datagram exceeded timelimit\n");
           n_byte+=1;
	   p_cnt->icmp_ip_exc_time_limit++;  // for the statistics
           break;
  case(12):if (COLORS) BLUE;
  	   printf("%-30s","datagram parameter problem\n");
           n_byte+=1;
	   p_cnt->icmp_ip_dtgr_param_prob++;  // for the statistics
           break;
  case(13):if (COLORS) BLUE;
  	   printf("%-30s","time stamp request\n");
           n_byte+=1;
	   p_cnt->icmp_ip_time_req++;  // for the statistics
           break;
  case(14):if (COLORS) BLUE;
  	   printf("%-30s","time stamp reply\n");
           n_byte+=1;
	   p_cnt->icmp_ip_time_rep++;   // for the statistics
           break;
  case(15):if (COLORS) BLUE;
  	   printf("%-30s","information request\n");
           n_byte+=1;
	   p_cnt->icmp_ip_info_req++;  // for the statistics
           break;
  case(16):if (COLORS) BLUE;
  	   printf("%-30s","information reply\n");
           n_byte+=1;
	   p_cnt->icmp_ip_info_rep++;  // for the statistics
           break;
  case(17):if (COLORS) BLUE;
  	   printf("%-30s","address mask request\n");
           n_byte+=1;
	   p_cnt->icmp_ip_addr_mask_req++;  // for the statistics
           break;
  case(18):if (COLORS) BLUE;
  	   printf("%-30s","address mask reply\n");
           n_byte+=1;
	   p_cnt->icmp_ip_addr_mask_rep++;  // for the statistics
           break;
  default: if (COLORS) BLUE;
  	   printf("unknown type:%d\n",buf[n_byte]);
           n_byte++;
	   p_cnt->icmp_ip_unknown++;  // for the statistics
           break;
 }
 else
 switch(buf[n_byte])  // switch out the type-field
 {
  case(0): n_byte+=8;
	   p_cnt->icmp_ip_echo_rep++;  // for the statistics
           break;         // echo reply 
  case(3): n_byte+=2;
           get_icmp_unreachable_code((char *) &code,buf[n_byte+1]);// for the statistics
           break;
  case(4): n_byte++;
	   p_cnt->icmp_ip_source_quench++;   // for the statistics
	   break;
  case(5): n_byte+=2;                     
           get_icmp_redirect_code ((char *) &code,buf[n_byte+1]);
           break;
  case(8): n_byte+=8;
	   p_cnt->icmp_ip_echo_req++;   // for the statistics
	   break;         // echo request
  case(11):n_byte++;
	   p_cnt->icmp_ip_exc_time_limit++;  // for the statistics
	   break;
  case(12):n_byte++;
	   p_cnt->icmp_ip_dtgr_param_prob++;  // for the statistics
	   break;
  case(13):n_byte++;
	   p_cnt->icmp_ip_time_req++;  // for the statistics
	   break;
  case(14):n_byte++;
	   p_cnt->icmp_ip_time_rep++;   // for the statistics
	   break;
  case(15):n_byte++;
	   p_cnt->icmp_ip_info_req++;  // for the statistics
	   break;
  case(16):n_byte++;
	   p_cnt->icmp_ip_info_rep++;  // for the statistics
	   break;
  case(17):n_byte++;
	   p_cnt->icmp_ip_addr_mask_req++;  // for the statistics
	   break;
  case(18):n_byte++;
	   p_cnt->icmp_ip_addr_mask_rep++;  // for the statistics
	   break;
  default: n_byte++;
	   p_cnt->icmp_ip_unknown++;  // for the statistics
	   break;
 }
 

// get_icmp_type((char *) &icmp_type,buf[n_byte]);  // get the type-string

  
// printf ("ICMP-TYPE: %-30s %s\n",icmp_type,code);
 
}



