/*
*
* APS - Advanced Packet Sniffer
*
*  Copyright (C) 1999 Christian Schulte
*
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*                                                                           
*/                                                                           

#include <unistd.h>
#include <stdio.h>
#include <errno.h>

unsigned int PIF_ID=-1;


                                                     
// ------- local includes 

#include <config.h>
#include <user_config.h>






int get_last_pif (void)   // find out the next number available for an APS-process
{
 int c,pid;
 FILE *F_pif;
 char fname[200];

 for (c=0;c<100;c++)
 {
   sprintf (fname,"%s/aps_%.4d.pif",PIF_PATH,c);
   if ( (F_pif=fopen(fname,"r")) == NULL) 
   {
     return(c);
   } // fname is allready existent ! ... okay
   else
   {
     fscanf(F_pif,"%u",&pid);
     getpgid(pid);
     if (errno==ESRCH)
     {
       printf("Stayled lock file (%s) found!!\n",fname);
       if (F_pif != NULL) fclose(F_pif);
       F_pif=0;
       if (unlink(fname)==0) { printf ("deleted ...\n"); c--; }
       else perror("while deleting lockfile");      
     }
   }
   if (F_pif != NULL) fclose (F_pif);
 }
 return(101);
}


int create_new_pif (unsigned int shmid)
{
 int c,pid;
 FILE *F_pif;
 char fname[200];
 
 
 for (c=0;c<100;c++)
 {
   sprintf (fname,"%s/aps_%.4d.pif",PIF_PATH,c);
   if ( (F_pif=fopen(fname,"r")) == NULL) 
   {
     if ( (F_pif=fopen(fname,"w")) == NULL) printf ("Can not create new PIF-File in %s \n",fname);
     else
     {
       printf ("Creating PIF-File (%s) with PID=%u and SHMID=%u\n",fname,getpid(),shmid);
       fprintf(F_pif,"%u %u",getpid(),shmid);
       PIF_ID=c;
       if (F_pif != NULL) fclose(F_pif);
       return(0);
     }
   } // fname is allready existent ! ... okay
   else 
   {
     fscanf(F_pif,"%u %u",&pid,&shmid);
     getpgid(pid);
     if (errno==ESRCH)
     {
       printf("Stayled lock file (%s) found!!\n",fname);
       if (F_pif != NULL) fclose(F_pif);
       F_pif=0;
       if (unlink(fname)==0) { printf ("deleted ...\n"); c--; }
       else perror("while deleting lockfile");
     }
   }
   if (F_pif != NULL) fclose (F_pif);
 }
 printf ("WARNING: Could not create %s ... no X-GUI available for this process !\n",fname);

 return(-1);
}



void kill_pif (void)
{
  char fname[200]; 
  FILE *F_pif;

  sprintf (fname,"%s/aps_%.4d.pif",PIF_PATH,PIF_ID); 
  if ( (F_pif=fopen(fname,"r")) != NULL)
  {
    if (F_pif != NULL) fclose(F_pif); 
    if (unlink(fname) == -1 ) { printf ("%s:",fname); perror("while deleting PIF-File"); }    // delete the PIF-File !!
  }
}




int get_shmid (void)
{
  int c;
  char fname[200];
  FILE *F_pif;
  unsigned int pid;
  unsigned int shmid;
 
  for (c=0;c<100;c++)
  {
    sprintf (fname,"%s/aps_%4.4d.pif",PIF_PATH,c);
    if ( (F_pif=fopen(fname,"r")) != NULL) 
    {
      fscanf(F_pif,"%u %u",&pid,&shmid);
      printf ("GOT IT: PID=%u shmid=%u\n",pid,shmid);
      return(shmid);
    }
    else
    return(-1);
  }
  return(-1);
}



