/*
*
* APS - Advanced Packet Sniffer
*
*  Copyright (C) 1999 Christian Schulte
*
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*                                                                           
*/                                                                           
                                                                             
#include <gtk/gtk.h>
#include <sys/time.h>
#include <sys/shm.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>


#include <aps_types.h>
#include <user_config.h>

// SOME DEFINES AND DECLARATIONS NOW -----------------------------------------------------------------------------
 
const char LABEL_NAMES[NUM_CNTRS][30]={
	"UDP-IP_ALL:",
	"TCP-IP_ALL:",
	"ECHO_REQESTS:",
	"ECHO_REPLIES:",
	"UNREACHABLE_NET:",
	"UNREACHABLE_HOST:",
	"UNREACHABLE_PROTO:",
	"UNREACHABLE_PORT:",
	"UN_FRAGM_NEEDED:",
	"UN_SOURCE_ROUTE:",
	"UNREACH_UNKOWN:",           // 10
	"SOURCE_QUENCH:",
	"REDIR_TO_HONET:",
	"REDIR_TO_HOST:",
	"REDIR_TO_TOS_NET:",
	"REDIR_TO_TOS_HOST:",
	"REDIR_UNKOWN:",
	"EXCEED_TIME_LIMIT:",
	"DGRAM_PARAM_PROBL:",
	"TIME_REQUEST:",
	"TIME_REPLY:",               // 20
	"INFO_REQUEST:",
	"INFO_REPLY:",
	"ADDR_MASK_REQ:",
	"ADDR_MASK_REPLY:",
	"ICMP-IP_UNKOWN:",
	"RARP_REQUEST:",
	"RARP_REPLY:",
	"ARP_REQUEST:",
	"ARP_REPLY:",
	"SAMBA/NETBIOS:",            // 30
	"LOOPBACK:",
	"IPX:",
	"COMPLETE_UNKOWN:"};








 a_un_cntrs *a_cntrs;     // have them all as a nice array ...  



 GtkWidget *update_opt_menu,*update_menu,*update_item,*update_menu_label,*reset_all_button;
 GtkWidget *a_rclb[NUM_CNTRS][4];                        // 0=reset-button 1=counter-entry 2=label 3=gtk-box containing the others
  
 GtkWidget *main_window;
 GtkWidget *main_table;

 // NOW SOME BOXES
 GtkWidget *main_box;

 signed int D_LEVEL=0;     // debug_level=0 (is default)
 unsigned int shmid,pid;   // where should we attach our data-field ??
 unsigned int updates_p_sec=12;



// ----------- some function declarations ...

extern int get_shmid (void);
void update_option_menu_select(GtkWidget *item, unsigned int sel_val);
GtkWidget *make_menu_item( gchar *name,GtkSignalFunc callback, gpointer data);
void sh_IO_ALRM (int num);
void local_init(void);


// ---------------------------------------- END OF GLOBAL VARS ... NOW SOME FUNCTIONS -----------------------------------



// This is borrowed from the GTK-Tutorial v1.2
void update_option_menu_select(GtkWidget *item, unsigned int sel_val)
{
 if (D_LEVEL>0) printf ("set update speed to %d updates per second\n",sel_val);
 updates_p_sec=sel_val;
}


// This is borrowed from the GTK-Tutorial v1.2
GtkWidget *make_menu_item( gchar *name,GtkSignalFunc callback, gpointer data)
{
 GtkWidget *item;
         
 item = gtk_menu_item_new_with_label (name);
 gtk_signal_connect (GTK_OBJECT (item), "activate", callback, data);
 gtk_widget_show (item);
 return(item);
}


// some reset-signal-handlers  (how the hell can i create an array of handlers ??)
// I hope i can clean this part up a bit in the next releases ... 

void reset_sigh_0(void)
{ a_cntrs->N[0]=0; }

void reset_sigh_1(void)
{ a_cntrs->N[1]=0; }

void reset_sigh_2(void)
{ a_cntrs->N[2]=0; }

void reset_sigh_3(void)
{ a_cntrs->N[3]=0; }

void reset_sigh_4(void)
{ a_cntrs->N[4]=0; }

void reset_sigh_5(void)
{ a_cntrs->N[5]=0; }

void reset_sigh_6(void)
{ a_cntrs->N[6]=0; }

void reset_sigh_7(void)
{ a_cntrs->N[7]=0; }

void reset_sigh_8(void)
{ a_cntrs->N[8]=0; }

void reset_sigh_9(void)
{ a_cntrs->N[9]=0; }

void reset_sigh_10(void)
{ a_cntrs->N[10]=0; }

void reset_sigh_11(void)
{ a_cntrs->N[11]=0; }

void reset_sigh_12(void)
{ a_cntrs->N[12]=0; }

void reset_sigh_13(void)
{ a_cntrs->N[13]=0; }

void reset_sigh_14(void)
{ a_cntrs->N[14]=0; }

void reset_sigh_15(void)
{ a_cntrs->N[15]=0; }

void reset_sigh_16(void)
{ a_cntrs->N[16]=0; }

void reset_sigh_17(void)
{ a_cntrs->N[17]=0; }

void reset_sigh_18(void)
{ a_cntrs->N[18]=0; }

void reset_sigh_19(void)
{ a_cntrs->N[19]=0; }

void reset_sigh_20(void)
{ a_cntrs->N[20]=0; }

void reset_sigh_21(void)
{ a_cntrs->N[21]=0; }

void reset_sigh_22(void)
{ a_cntrs->N[22]=0; }

void reset_sigh_23(void)
{ a_cntrs->N[23]=0; }

void reset_sigh_24(void)
{ a_cntrs->N[24]=0; }

void reset_sigh_25(void)
{ a_cntrs->N[25]=0; }

void reset_sigh_26(void)
{ a_cntrs->N[26]=0; }

void reset_sigh_27(void)
{ a_cntrs->N[27]=0; }

void reset_sigh_28(void)
{ a_cntrs->N[28]=0; }

void reset_sigh_29(void)
{ a_cntrs->N[29]=0; }

void reset_sigh_30(void)
{ a_cntrs->N[30]=0; }

void reset_sigh_31(void)
{ a_cntrs->N[31]=0; }

void reset_sigh_32(void)
{ a_cntrs->N[32]=0; }

void reset_sigh_33(void)
{ a_cntrs->N[32]=0; }



void reset_all_sigh(void)
{
  unsigned int c; 

  for (c=0;c<NUM_CNTRS;c++)
   a_cntrs->N[c]=0; 
}




void sh_IO_ALRM (int num)
{
 unsigned int c;
 struct itimerval tval,otval;
 char dtext[30]="";

 tval.it_value.tv_sec=0;
 tval.it_value.tv_usec=1000000/updates_p_sec;
 tval.it_interval.tv_sec=0;
 tval.it_interval.tv_usec=0;
 setitimer(ITIMER_REAL,&tval,&otval);

 for (c=0;c<33;c++)
 {
  sprintf(dtext,"%u",a_cntrs->N[c]);
  gtk_entry_set_text(GTK_ENTRY(a_rclb[c][1]),dtext);  
 }
}



void local_init(void)
{ 
 if ( (shmid=get_shmid()) == -1) { printf ("Could not get PIF-File in %s (APS not running) ??\n",PIF_PATH); exit(1); }
 
 if (D_LEVEL>0) printf ("Got SHMID=%u \n",shmid);
 
 if ( (int) (a_cntrs=(a_un_cntrs*) shmat(shmid,0,0)) == -1 )   // attach the allocated segment 
 { perror ("could not attach SHMEM-SEGMENT"); exit (1); }
 
 signal(SIGALRM,sh_IO_ALRM); 
 alarm(1);
}







// ------------------------------------- AND HERE COMES THE MAIN -------------------------------------




int main (void)
{
 int c;

 local_init();
 gtk_init(NULL,NULL);

 main_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);   // get a new window to display all this shit !!

 main_table=gtk_table_new(20,6,TRUE);
 
 for (c=0;c<NUM_CNTRS;c++)       // create all the boxes into that the counters, buttons and labels will be packed
   a_rclb[c][3]=gtk_hbox_new(FALSE,2);


// create a drop-down for selection of UPDATE-RATE    (with a GTK_OPTION_MENU)
 update_opt_menu=gtk_option_menu_new();
 update_menu=gtk_menu_new();
 
 update_item=make_menu_item("1 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(1));
 gtk_menu_append (GTK_MENU(update_menu),update_item);
 update_item=make_menu_item("2 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(2));
 gtk_menu_append (GTK_MENU(update_menu),update_item);
 update_item=make_menu_item("4 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(4));
 gtk_menu_append (GTK_MENU(update_menu),update_item);
 update_item=make_menu_item("8 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(8));
 gtk_menu_append (GTK_MENU(update_menu),update_item);
 update_item=make_menu_item("12 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(12));
 gtk_menu_append (GTK_MENU(update_menu),update_item);
 update_item=make_menu_item("16 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(16));
 gtk_menu_append (GTK_MENU(update_menu),update_item);
 update_item=make_menu_item("32 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(32));
 gtk_menu_append (GTK_MENU(update_menu),update_item);
 update_item=make_menu_item("64 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(64));
 gtk_menu_append (GTK_MENU(update_menu),update_item);
 update_item=make_menu_item("128 per second",GTK_SIGNAL_FUNC(update_option_menu_select),GINT_TO_POINTER(128)
 );
 gtk_menu_append (GTK_MENU(update_menu),update_item);

 gtk_option_menu_set_menu(GTK_OPTION_MENU(update_opt_menu),update_menu);

 gtk_option_menu_set_history(GTK_OPTION_MENU(update_opt_menu),4);   // set 8 per second as default !!

 gtk_widget_set_usize(GTK_WIDGET(update_opt_menu),130,-1);

 update_menu_label=gtk_label_new("Update frequency:");

 gtk_table_attach(GTK_TABLE(main_table),update_menu_label,0,1,2,3,0,0,5,0);
 gtk_table_attach(GTK_TABLE(main_table),update_opt_menu,1,2,2,3,0,0,5,0);



 reset_all_button=gtk_button_new_with_label (" Reset all ");
 gtk_signal_connect (GTK_OBJECT(reset_all_button),"clicked",GTK_SIGNAL_FUNC(reset_all_sigh),NULL);
 gtk_table_attach(GTK_TABLE(main_table),reset_all_button,1,2,3,4,0,0,5,0);



// create all the buttons, lables and counter-entries -----------------------------------

 for (c=0;c<NUM_CNTRS;c++)
 {
  a_rclb[c][0]=gtk_button_new_with_label ("R");
  a_rclb[c][1]=gtk_entry_new_with_max_length(10);
  gtk_widget_set_usize(GTK_WIDGET(a_rclb[c][1]),75,-1);
  a_rclb[c][2]=gtk_label_new(LABEL_NAMES[c]);
  gtk_entry_set_text(GTK_ENTRY(a_rclb[c][1]),"0");

// pack all this into it own box ...
//  gtk_box_pack_start(GTK_BOX(a_rclb[c][3]),a_rclb[c][2],FALSE,FALSE,0); 
  gtk_box_pack_start(GTK_BOX(a_rclb[c][3]),a_rclb[c][1],FALSE,FALSE,0);
  gtk_box_pack_start(GTK_BOX(a_rclb[c][3]),a_rclb[c][0],FALSE,FALSE,0);
 }

 // and now add them to the main_window --------------------------------------------------
 gtk_container_add(GTK_CONTAINER(main_window),main_table);


// attach all the created boxes to the main_table so that it makes at least a little sense

 
 gtk_table_attach(GTK_TABLE(main_table),a_rclb[0][2],0,1,0,1,0,0,5,0);
 gtk_table_attach(GTK_TABLE(main_table),a_rclb[0][3],1,2,0,1,0,0,5,0);
 
 gtk_table_attach(GTK_TABLE(main_table),a_rclb[1][2],2,3,0,1,0,0,5,0);
 gtk_table_attach(GTK_TABLE(main_table),a_rclb[1][3],3,4,0,1,0,0,5,0);



 for (c=2;c<=18;c++)
 {
   gtk_table_attach(GTK_TABLE(main_table),a_rclb[c][2],4,5,c,c+1,0,0,5,0);  // ICMP UNREACHABLEs and REDIRs
   gtk_table_attach(GTK_TABLE(main_table),a_rclb[c][3],5,6,c,c+1,0,0,5,0);
 }


 for (c=19;c<=25;c++)
 {
   gtk_table_attach(GTK_TABLE(main_table),a_rclb[c][2],2,3,c-7,c-6,0,0,5,0);  // THE ICMP-TIME/INFO/ADDR REQ/REP 
   gtk_table_attach(GTK_TABLE(main_table),a_rclb[c][3],3,4,c-7,c-6,0,0,5,0); 
 }


 for (c=26;c<=29;c++)
 {
   gtk_table_attach(GTK_TABLE(main_table),a_rclb[c][2],0,1,c-20,c-19,0,0,5,0);  // THE ICMP-TIME/INFO/ADDR REQ/REP 
   gtk_table_attach(GTK_TABLE(main_table),a_rclb[c][3],1,2,c-20,c-19,0,0,5,0); 
 }


 gtk_table_attach(GTK_TABLE(main_table),a_rclb[30][2],0,1,11,12,0,0,5,0);  // THE ICMP-TIME/INFO/ADDR REQ/REP 
 gtk_table_attach(GTK_TABLE(main_table),a_rclb[30][3],1,2,11,12,0,0,5,0); 



 gtk_table_attach(GTK_TABLE(main_table),a_rclb[31][2],0,1,13,14,0,0,5,0);  // THE ICMP-TIME/INFO/ADDR REQ/REP 
 gtk_table_attach(GTK_TABLE(main_table),a_rclb[31][3],1,2,13,14,0,0,5,0); 



 gtk_table_attach(GTK_TABLE(main_table),a_rclb[32][2],0,1,15,16,0,0,5,0);  // THE ICMP-TIME/INFO/ADDR REQ/REP 
 gtk_table_attach(GTK_TABLE(main_table),a_rclb[32][3],1,2,15,16,0,0,5,0); 



 gtk_table_attach(GTK_TABLE(main_table),a_rclb[33][2],0,1,17,18,0,0,5,0);  // THE ICMP-TIME/INFO/ADDR REQ/REP 
 gtk_table_attach(GTK_TABLE(main_table),a_rclb[33][3],1,2,17,18,0,0,5,0); 



// last but not least connect the buttons to what they belong !
 gtk_signal_connect (GTK_OBJECT(a_rclb[0][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_0),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[1][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_1),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[2][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_2),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[3][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_3),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[4][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_4),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[5][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_5),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[6][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_6),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[7][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_7),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[8][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_8),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[9][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_9),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[11][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_10),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[12][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_11),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[13][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_12),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[14][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_13),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[15][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_15),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[16][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_16),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[17][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_17),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[18][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_18),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[19][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_19),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[20][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_20),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[21][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_21),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[22][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_22),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[23][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_23),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[24][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_24),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[25][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_25),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[26][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_26),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[27][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_27),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[28][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_28),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[29][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_29),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[30][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_30),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[31][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_31),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[32][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_32),NULL);
 gtk_signal_connect (GTK_OBJECT(a_rclb[33][0]),"clicked",GTK_SIGNAL_FUNC(reset_sigh_33),NULL);



 gtk_widget_show_all (main_window);
 
 gtk_main();

 return(0);
}



