/*
*
* APS - Advanced Packet Sniffer
*
*  Copyright (C) 1999 Christian Schulte
*
*    This program is free software; you can redistribute it and/or modify
*    it under the terms of the GNU General Public License as published by
*    the Free Software Foundation; either version 2 of the License, or
*    (at your option) any later version.
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*
*/




#include <aps_types.h>
#include <stdio.h>
#include <lansi.h>


// here the tcp part is printed ...

const char FLAGS_SET[6][4]={"FIN","SYN","RST","PSH","ACK","URG"};
const char FLAGS_CLRD[6][4]={"fin","syn","rst","psh","ack","urg"};
extern unsigned int PRINT_MODE,G_OPTS;
extern unsigned char COLORS,BEEPING;


// *******************

void tcp_info(void);
 
void pnum_pname(unsigned int p1,unsigned int p2,char *s);


// *******************

extern unsigned char buf[10002];
extern unsigned int n_byte;
extern s_aps_cntr *p_cnt;


void tcp_info(void);


void tcp_info(void)
{
unsigned int s_port=0,d_port=0;
char pname[50],flags,c;

  if (COLORS) GREEN;

  s_port=(buf[n_byte+0]<<8)+buf[n_byte+1];
  d_port=(buf[n_byte+2]<<8)+buf[n_byte+3];  
 
  pnum_pname(s_port,d_port,(char *) &pname);

  if(BEEPING)
  {
    if (d_port == 23 || s_port == 23)  // Telnet
    BEEP;
    if (d_port == 22 || s_port == 22) // SSH
    BEEP;
    if (d_port == 21 || s_port == 21)  // FTP
    BEEP;
    if (d_port == 80 || s_port == 80) // WEB
    BEEP;
    if (d_port == 3128 || s_port == 3128) // Squid cache 
    BEEP;
    if (d_port == 119 || s_port == 119) // NNTP
    BEEP;
  }

  if (!(G_OPTS&0x02))       // Talk to them if not VERY-QUIET-MODE !!
  {
    if (COLORS) BOLD;
    printf ("TCP-HEADER:\nPorts: %0.4d-->%0.4d (%s) ",s_port,d_port,pname);
    printf ("Seq./Ack. Nr.:0x%0.8x / 0x%0.8x\n",
    ((buf[n_byte+4]<<24)+(buf[n_byte+5]<<16)+(buf[n_byte+6]<<8)+buf[n_byte+7]),
    ((buf[n_byte+8]<<24)+(buf[n_byte+9]<<16)+(buf[n_byte+10]<<8)+buf[n_byte+11]));
  
    printf ("Data-Offset:0x%0.2x  Reserved-6Bit:%0.2x  Flags:",
    buf[n_byte+12]>>4,((buf[n_byte+12]&0xf)<<2)+(buf[n_byte+13]&0xc0)>>6);
  
    flags=buf[n_byte+13];
    for (c=5;c>=0;c--)
    {
     if ((flags>>c)&0x01) printf ("-%s",FLAGS_SET[c]);
     else printf ("-%s",FLAGS_CLRD[c]);
    }
    printf ("-\n");
    printf ("Window:0x%0.4x  CRC:0x%0.4x  ",
    ((buf[n_byte+14]<<8)+buf[n_byte+15]),((buf[n_byte+16]<<8)+buf[n_byte+17]));

    printf ("Urgent-Pointer:0x%0.4x\n",((buf[n_byte+18]<<8)+buf[n_byte+19]));
    if (COLORS) NORMAL;
  } 
 
  n_byte+=20; // Now we are here !

  p_cnt->tcp_ip++;
}
 
