/*
** x_util.h
*/

/*
** Copyright 1999 by Todd Allen.  All Rights Reserved.  Permission to use,
** copy, modify, distribute, and sell this software and its documentation for
** any purpose is hereby granted without fee, provided that the above
** copyright notice appear in all copies and that both the copyright notice
** and this permission notice appear in supporting documentation.
**
** No representations are made about the suitability of this software for any
** purpose.  It is provided ``as is'' without express or implied warranty,
** including but not limited to the warranties of merchantability, fitness
** for a particular purpose, and noninfringement.  In no event shall Todd
** Allen be liable for any claim, damages, or other liability, whether in
** action of contract, tort, or otherwise, arising from, out of, or in
** connection with this software.
*/

#ifndef __X_UTIL_H
#define __X_UTIL_H

#include <X11/Intrinsic.h>
#include <X11/xpm.h>

typedef struct {
   String         name;
   String         mask_name;
   Pixmap         pixmap;
   Pixmap         mask;
   XpmAttributes  attributes;
} XpmIcon;

extern   Pixel    XUGetColor     (Display*   display,
                                  String     name);
extern   Boolean  XULoadPixmap   (Display*   display,
                                  XpmIcon*   icon,
                                  char*      default_pixmap[],
                                  Pixel      default_fg,
                                  Pixel      default_bg,
                                  String     purpose);
extern   XpmIcon  XUPadPixmap    (Display*   display,
                                  XpmIcon    src,
                                  Dimension  pad_width,
                                  Dimension  pad_height);

#endif
