#include <config.h>

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif
#if TIME_WITH_SYS_TIME
# ifdef WIN32
#  include <sys/timeb.h>
# else
#  include <sys/time.h>
# endif
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif
#if STDC_HEADERS
#include <string.h>
#include <stdlib.h>
#else
#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#endif
#if HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#if HAVE_WINSOCK_H
#include <winsock.h>
#endif

#include "asn1.h"
#include "snmp_api.h"
#include "mib.h"
#include "snmp.h"
#include "snmp_impl.h"
#include "parse.h"

extern struct tree *tree_head;

static int debug = 0;

/***********************************************************
#define TYPE_OTHER          0
#define TYPE_OBJID          1
#define TYPE_OCTETSTR       2
#define TYPE_INTEGER        3
#define TYPE_NETADDR        4
#define TYPE_IPADDR         5
#define TYPE_COUNTER        6
#define TYPE_GAUGE          7
#define TYPE_TIMETICKS      8
#define TYPE_OPAQUE         9
#define TYPE_NULL           10
#define TYPE_COUNTER64      11
#define TYPE_BITSTRING      12
#define TYPE_NSAPADDRESS    13
#define TYPE_UINTEGER       14

#define ACCESS_READONLY    18
#define ACCESS_READWRITE   19
#define	ACCESS_WRITEONLY   20
#define ACCESS_NOACCESS    21
#define ACCESS_NOTIFY      67
#define ACCESS_CREATE      48
***********************************************************/

#define HEADER "SNMP"
static char header[255];


void create_subtree(tree)
    struct tree *tree;
{
    struct tree *tp;
    int i, isTable;
    char hierarchy[1024], command[1024];
    struct tree *treeHierarchy[64];

    tp = tree;

    for(i=0; tp != NULL; i++) {
      treeHierarchy[i] = tp;
      tp = tp->parent;
    }
    
    if(i > 6) {
      for(i-=7, hierarchy[0] = '\0'; i>=0; i--) {
	strcat(hierarchy, treeHierarchy[i]->label);
	strcat(hierarchy, "/");
      }
      
      if(debug) 
	printf("Hierarchy %s/%s\n", header, hierarchy);

      sprintf(command, "mkdir -p %s/%s", header, hierarchy);
      if(debug) printf("1) %s\n", command);
      system(command);
     
      if (tree->type == TYPE_SEQUENCEOF)
	{
	  for(i=strlen(hierarchy)-1; i>0; i--)
	    if(hierarchy[i] == '/') {
	      hierarchy[i] = '\0';
	      break;
	    }

	  sprintf(command, "touch %s/%s", header, hierarchy); /* Table entry */
	  system(command);
	  sprintf(command, "touch %s/%s.html", header, hierarchy); /* Table entry */
	  system(command);
	  sprintf(command, "touch %s/%s.slk", header, hierarchy); /* Table entry */
	  system(command);
	  sprintf(command, "touch %s/%s.txt", header, hierarchy); /* Table entry */
	  system(command);
	}

      if(debug) printf("Children of %s(%ld):\n", tree->label, tree->subid); 
      
      if(debug) {
        printf("%s(%ld) type=%d, access=%d",
	       tree->label, tree->subid, tree->type, tree->access);
        if (tree->tc_index != -1) printf(" tc=%d", tree->tc_index);
        if (tree->hint) printf(" hint=%s", tree->hint);
        if (tree->units) printf(" units=%s", tree->units);
	printf("\n");
      } else {
	fprintf(stdout, ".");
	fflush(stdout);
      }

      for(tp = tree->child_list; tp; tp = tp->next_peer){
	if((tp->type != TYPE_OTHER) && (tp->type != TYPE_SEQUENCEOF)) {
	  if (tp->parent->parent->type == TYPE_SEQUENCEOF)
	    sprintf(command, "touch %s/%s%s", header, hierarchy, tp->label); /* Table entry */
	  else 
	    sprintf(command, "touch %s/%s%s.0", header, hierarchy, tp->label);

	  if(debug) printf("2) %s\n", command);
	  system(command);
	}

	if(debug) {
	  printf("%s(%ld) type=%d, access=%d",
		 tp->label, tp->subid, tp->type, tp->access);
	  if (tp->tc_index != -1) printf(" tc=%d", tp->tc_index);
	  if (tp->hint) printf(" hint=%s", tp->hint);
	  if (tp->units) printf(" units=%s", tp->units);
	  printf("\n");
	}	
      }
    }

    for(tp = tree->child_list; tp; tp = tp->next_peer){
        if (tp->child_list)
            create_subtree(tp);
    }

}

/***********************************************************/

void set_subtree_ownership(tree)
    struct tree *tree;
{
    struct tree *tp;
    int i, isTable;
    char hierarchy[1024], command[1024];
    struct tree *treeHierarchy[64];

    tp = tree;

    for(i=0; tp != NULL; i++) {
      treeHierarchy[i] = tp;
      tp = tp->parent;
    }
    
    if(i > 6) {
      for(i-=7, hierarchy[0] = '\0'; i>=0; i--) {
	strcat(hierarchy, treeHierarchy[i]->label);
	strcat(hierarchy, "/");
      }
      
      if(debug) 
	printf("Hierarchy %s/%s\n", header, hierarchy);

      sprintf(command, "chmod 777 %s/%s; chown nobody %s/%s", 
	      header, hierarchy, header, hierarchy);
      if(debug) printf("1) %s\n", command);
      system(command);
      
      if (tree->type == TYPE_SEQUENCEOF)
	{
	  for(i=strlen(hierarchy)-1; i>0; i--)
	    if(hierarchy[i] == '/') {
	      hierarchy[i] = '\0';
	      break;
	    }

	  sprintf(command, "chmod 444 %s/%s.html; chown nobody %s/%s.html", 
		  header, hierarchy, 
		  header, hierarchy);
	  system(command);
	  sprintf(command, "chmod 444 %s/%s.slk; chown nobody %s/%s.slk", 
		  header, hierarchy,
		  header, hierarchy);
	  system(command);
	  sprintf(command, "chmod 444 %s/%s.txt; chown nobody %s/%s.txt", 
		  header, hierarchy,
		  header, hierarchy);
	  system(command);
	}
      
      if(debug) printf("Children of %s(%ld):\n", tree->label, tree->subid); 
      
      if(debug) {
        printf("%s(%ld) type=%d, access=%d",
	       tree->label, tree->subid, tree->type, tree->access);
        if (tree->tc_index != -1) printf(" tc=%d", tree->tc_index);
        if (tree->hint) printf(" hint=%s", tree->hint);
        if (tree->units) printf(" units=%s", tree->units);
	printf("\n");
      } else {
	fprintf(stdout, ".");
	fflush(stdout);
      }

      for(tp = tree->child_list; tp; tp = tp->next_peer){
	if((tp->type != TYPE_OTHER) && (tp->type != TYPE_SEQUENCEOF)) {

	  if (tp->parent->parent->type == TYPE_SEQUENCEOF) {
	    sprintf(command, "chmod 666 %s/%s%s; chown nobody %s/%s%s", 
		    header, hierarchy, tp->label,
		    header, hierarchy, tp->label);
	    system(command);
	  }
	  else {
	    if((tp->access == ACCESS_READONLY) || (tp->access == ACCESS_NOACCESS))
	      sprintf(command, "chmod 444 %s/%s%s.0; chown nobody %s/%s%s.0", 
		      header, hierarchy, tp->label,
		      header, hierarchy, tp->label);
	    else
	      sprintf(command, "chmod 666 %s/%s%s.0; chown nobody %s/%s%s.0", 
		      header, hierarchy, tp->label,	    
		      header, hierarchy, tp->label); 
	    system(command);
	  }
	}

	if(debug) {
	  printf("%s(%ld) type=%d, access=%d",
		 tp->label, tp->subid, tp->type, tp->access);
	  if (tp->tc_index != -1) printf(" tc=%d", tp->tc_index);
	  if (tp->hint) printf(" hint=%s", tp->hint);
	  if (tp->units) printf(" units=%s", tp->units);
	  printf("\n");
	}	
      }
    }

    for(tp = tree->child_list; tp; tp = tp->next_peer){
        if (tp->child_list)
	  set_subtree_ownership(tp);
    }

}



/***********************************************************/

main(argc, argv)
     int argc;
     char *argv[];
{
  char hostName[64], command[255];
  
  if(gethostname(hostName, 64) == 0)
    sprintf(header, "%s/%s", HEADER, hostName);
  else
    sprintf(header, "%s/localhost", HEADER);

  /* Create the folder containing the traps to send */
  sprintf(command, "mkdir -p %s/sendTraps", header);
  system(command);
  sprintf(command, "chmod 777 %s/sendTraps; "
	  "chown nobody %s/sendTraps", 
	  header, header);
  system(command);

  /* MIB parsing... */
  printf("Parsing MIB...\n");
  init_mib();
  
  printf("Creating tree hierarchy...\n");
  if(debug)
    print_subtree(stdout, tree_head, 0);
  create_subtree(tree_head, 0);
  printf("\n");
  set_subtree_ownership(tree_head, 0);

  printf("\nDone.\n");
}
