/*
 * pphw.h
 *
 * Header file for hardware-level routines used by the PIC84PGM project.
 *
 * Revision history:
 *
 * 30-Aug-1996: V-0.0; wrote definitions
 * 03-Apr-1998: V-0.1; updated for PP V-0.5
 *
 * Copyright (C) 1996 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or exploited for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */

#ifndef __PPHW_H
#define __PPHW_H

#ifndef LINUX
	#include <dos.h>
#endif // not LINUX

#include "timer.h"

#ifdef _MSC_VER                         /* changes for Microsoft C V7.00 */
#define outportb(p,v)        _outp(p,v)
#define inportb(p)           _inp(p)
#endif

#define IN      64
#define VPP     8
#define VDD     4
#define CLK     2
#define OUT     1

#define STOP    0
#define GO      1

#define TDLY            TICKS(5)                /* default delay */
#define PWRDLY          TICKS(25000)            /* power-up delay (25ms) */

extern int d_reg;
extern int dumpfmt;

int interact(int wait);
void run_mode(int mode);
void prog_mode(void);
void out_word(int w);
int in_word(void);
void command(int cmd);
void cleanup(void);
int setup(void);

#endif  /* __PPHW_H */
