/* $Id: search.c,v 1.1 1998/08/01 16:03:14 dg8xt Exp $ */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include "global.h"
#include "log.h"
#include "misc.h"
#include "result.h"


/* search for filename */
void search(int opt_w, char *search_for, char *data_file)
{
   struct stat statbuf;	/* need for fstat */
   FILE *stream;
   char line[1024];
   char fname[1024];
   char open_file[1024];
   char hostname[256];
   char *buf;
   int found=0;
   int pack=0;		/* data_file .gz or .Z */
   int t;		/* temp int for returnstatus */

   /* split name of data_file  i.e. 'dg8xt.ampr.org:00_find.gz'	*/
   buf=strchr(data_file, ':'); /* :00_find.gz */
   strncpy(hostname, data_file, (strlen(data_file) - strlen(buf)));
   hostname[(strlen(data_file) - strlen(buf))]=0; /* dg8xt.ampr.org */

   /* must done this first, because with popen you will
      not get the ctime from data_file */
   sprintf(open_file, "%s/%s", DATA_DIR, data_file); /* DATA_DIR in global.h */

   if ((stream = fopen(open_file,"r")) == NULL )
      error_log(open_file);	/* write error log and exit */

   fstat(fileno(stream), &statbuf);  /* get time last changed */
   fclose(stream);

   /* check if the data_file is compressed */
   buf=strrchr(data_file, '.')+1;
   if( (strcmp(buf, "gz") == 0) || (strcmp(buf, "Z") == 0) )
      pack++;

   if(pack)
   {
                        	      /* PACK_PROG, DATA_DIR in global.h */
      sprintf(open_file, "%s -dc %s/%s", PACK_PROG, DATA_DIR, data_file);
      if ((stream = popen(open_file,"r")) == NULL )
         error_log(open_file);	/* write error log and exit */
   } else {
                	      /*  DATA_DIR in global.h */
      sprintf(open_file, "%s/%s", DATA_DIR, data_file);
      if ((stream = fopen(open_file,"r")) == NULL )
         error_log(open_file);	/* write error log and exit */
   }
   
   printf("\n\nhost %s\n", hostname);
   printf("Last updated: %s\n", ctime(&statbuf.st_mtime));

   fgets(line, 1024,stream);
   fgets(line, 1024,stream); /* done this twice, because we do not
                        	need the first line */
      
   while( !feof(stream) )
   {
      /* extract filename from line */
      strcpy(fname, (buf=strrchr(line, '/')+1) );
      convert_lower_to_upper(fname, strlen(fname));	/* misc.h */

      if (strstr(fname, search_for) != 0)
      {
      	found++;
      	print_result(opt_w, line, hostname);	/* result.h */
      }
      
      fgets(line, 1024,stream);
   }

   if(!found)
      printf("  %s not found.\n\n", search_for);

   if(pack)
   {
      if ((t = pclose(stream)) != 0)
      {
      	/* done this because popen will not return NULL,
           if /bin/sh could not execute the PACK_PROG */
      	error_log(open_file);	/* write error log and exit */
      }
   } else {
      fclose(stream);
   }
}

