/* $Id: result.c,v 1.1 1998/08/01 16:03:14 dg8xt Exp $ */

#include <stdio.h>
#include <string.h>

void print_result(int opt_w, char *line, char *hostname)
{
   char permissions[11];
   char size[10];
   char month_day[7];
   char year[5];
   char str1[1024];
   char hostname_old[256];
   char location[1024];
   char location_old[1024];
   char *fname;

   /* extract line */
   strncpy(permissions, line, 10);
   permissions[10]=0;
   strncpy(size, line+23, 9);
   size[9]=0;
   strncpy(month_day, line+37, 6);
   month_day[6]=0;
   strncpy(year, line+53, 4);
   year[4]=0;
   strncpy(str1, line+58, 255);
   str1[strlen(line)-59]=0;

   /* extract filename */
   fname=strrchr(str1, '/')+1;

   /* read new file ? then we need to clear location */
   if (strcmp(hostname, hostname_old) != 0)
   {
      strcpy(hostname_old, hostname);
      strcpy(location, "");
   }

   strcpy(location_old, location);
   strncpy(location, str1, strlen(str1)-strlen(fname)-1);
   location[strlen(str1)-strlen(fname)-1]=0;
      
   /* new location ? */
   if (strcmp(location, location_old) != 0)
      printf("\n    Location: /%s\n", location);
      
   /* file or directory ? */
   if (line[0] == '-')
   {
      printf("           FILE ");
   } else {
      printf("      DIRECTORY ");
   } 

   /* all done, print it */
   printf(" %s %s  %s %s ", permissions, size, month_day, year);

   if (opt_w)  /* HTML output */
   {
      printf("<A HREF=\"ftp://%s/%s/%s\">%s</A>\n",  hostname, location, fname, fname);
   } else {
      printf("%s\n", fname);
   }
}

