/* $Id: psearch.c,v 1.1 1998/08/01 16:03:14 dg8xt Exp $ */

/*
 * PSEARCH is Copyright (C) 1998 by Thomas Weinell <dg8xt@db0hht.ampr.org>
 *
 * PSEARCH is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; version 2 dated June, 1991
 *
 * PSEARCH is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PSEARCH; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include "global.h"
#include "log.h"
#include "misc.h"
#include "result.h"
#include "usage.h"
#include "search.h"
#include "sock.h"
#include "version.h"

const char progname[16]="psearch";

int main(int argc, char **argv)
{
   DIR *dir;
   struct dirent *ent;
   
   char search_for[255];
   char server[255]="";
   char temp[255];
   extern char *optarg;
   extern int optind;   /* number of scanned args with getopt */
   int opt;             /* option to test for */
   int opt_w=0;		/* HTML output */
   int port=0;
   
   /* check if somebody is so stupid to run as uid root */
   check_root();	/* log.h */

   if( !argv[1] )
   {
      exit(usage());
   }
   /* scan the command line on options */
   while ((opt=getopt(argc, argv, "hHI?vws:p:")) > 0) {
      switch (opt) {
         case 'I': exit(usage_long());	/* long help (Info) */
                   break;
         case 'v': printf("%s %s\n", progname, VERSION); /* version */
            	   exit (2);
                   break;
         case 'w': opt_w++; 		/* HTML output */
                   break;
         case 's': strcpy(server, optarg); /* -s <server> */
                   break;
         case 'p': port = atoi(optarg);	   /* port (defaut 7001) */
                   break;
         case ':':
         case '?':
         case 'h':
         case 'H': 
         default:  exit(usage());	/* short help  */
                   break;

      }
   }

   strcpy(search_for, argv[argc-1]);
   convert_lower_to_upper(search_for, strlen(search_for));	/* misc.h */
   check_search(search_for);	/* misc.h */

   /* remote request */
   if(*server)
   {
      if (!port)
      	port = DEFAUT_PORT;	/* global.h */

      if (opt_w) 
      {
      	strcpy(temp, search_for);
        sprintf(search_for, "-w %s", temp);
      }

      strcpy(temp, search_for);
      sprintf(search_for, "prog %s\r\n", temp);

      connect_to(server, port, search_for);	/* sock.h */
      exit (0);
   }
   
   if ((dir = opendir(DATA_DIR)) == NULL)
   {
      /* write error log and exit */
      error_log(DATA_DIR);	/* log.h */
      exit (1);
   }
   
   while ((ent = readdir(dir)) != NULL)
   {
      if (strstr(ent->d_name, ":00_find") != NULL)  /* look for data_files */
         search(opt_w, search_for, ent->d_name);    /* search.h */
   }
   closedir(dir);

   return 0;
}

