#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "log.h"
#include "recursiv_path.h"


/* ------------------------------------------------------------ */
/* add an entry to struct					*/
/* return:  0 on success, 1 if false				*/
/* ------------------------------------------------------------ */

int add_entry_recursive_pathname(char *string)
{
   struct recursive_pathname *p;

   /* allocate memory for new entry */
   p = (struct recursive_pathname *) malloc(sizeof(struct recursive_pathname));
   if (!p) {
      error_log("can not malloc struct recursive_pathname","");
      return 1;
   }
   
   /* add entry */
   strcpy(p->name, string);
   p->next = Recursive_pathname;
   Recursive_pathname = p;
   
   return 0;
}                                 
   

/* ------------------------------------------------------------ */
/* do we have an entry ?					*/
/* return: TRUE = 0  FALSE = 1 					*/
/* ------------------------------------------------------------ */

int check_entry_recursive_pathname(char *search_string)
{
   struct recursive_pathname *p;
   for (p = Recursive_pathname; p; p = p->next)
      if( !strncmp(p->name, search_string, strlen(p->name)) )
         return 0;
   return 1;
}

