/* $Id: read_config.c,v 1.1 1999/03/27 14:18:33 dg8xt Exp $ */

#include <stdio.h>
#include <string.h>
#include "exact_path.h"
#include "filename.h"
#include "global.h"
#include "log.h"
#include "recursiv_path.h"


/* ------------------------------------------------------------ */
/* read the config file						*/
/* return: 0 on success, 1 if false				*/
/* ------------------------------------------------------------ */

int read_config(char *conf_file)
{
   FILE *conf;
   char line[255];
   char *command;
   char *value;
   
   if(! *conf_file)
      conf_file = CONFIG_FILE;

   /* open config file */
   if( (conf = fopen(conf_file ,"r")) == NULL ) {
      error_log("can not open config file", conf_file);
      return 1;
   }
   
   /* read config file */
   while( fgets(line, 255, conf) != NULL) {
      command = strtok(line, " \t");
      value = strtok(NULL, " \t");

      if(value) {
         /* strip '\n' */
         if(value[(strlen(value))-1]=='\n')
            value[(strlen(value))-1]=0;
         /* check for commands */
         if( strcmp(command, "filename") == 0 )
            add_entry_filename(value);
         if( strcmp(command, "exact_path") == 0 )
            add_entry_exact_pathname(value);
         if( strcmp(command, "recursive_path") == 0 )
            add_entry_recursive_pathname(value);
      }         
   }
   
   fclose(conf);
   return 0;
}

