/* $Id: post.c,v 1.1 1999/03/27 14:18:33 dg8xt Exp $ */

#include <stdio.h>
#include "global.h"
#include "log.h"
#include "parse_input.h"
#include "post.h"


/* -------------------------------------------------------------------- */
/* open pipe to inews							*/
/* return: none								*/
/* -------------------------------------------------------------------- */

void open_inews()
{
   char inews_cmd[1024];

#ifndef HAVE_INEWS
   error_log("no inews defined. posting disabled","");
   exit(-1);
#endif

   sprintf(inews_cmd, "%s -h\n", INEWS_PROG);

   if((out = popen(inews_cmd, "w")) == NULL) {
      error_log("Unable to open pipe to inews", inews_cmd);
      exit(-1);
   }

   fprintf(out, "Newsgroups: %s\n", NEWSGROUP);
   fprintf(out, "From: %s\n", FROM);
   fprintf(out, "Subject: %s\n", SUBJECT);
   fprintf(out, "\n");
}


/* -------------------------------------------------------------------- */
/* close pipe to inews							*/
/* return: none								*/
/* -------------------------------------------------------------------- */

void close_inews(void)
{
   fprintf(out, "\n");
   if( (pclose(out)) != 0 ) {
      /* done this because popen will not return NULL,
         if /bin/sh could not execute sendmail */
      error_log("unable to close pipe to inews","");
   }
}

