/* $Id: parse_input.c,v 1.1 1999/03/27 14:18:33 dg8xt Exp $ */

#include <stdio.h>
#include <string.h>
#include "exact_path.h"
#include "filename.h"
#include "log.h"
#include "mail.h"
#include "parse_input.h"
#include "post.h"
#include "recursiv_path.h"


void parse_input(char *line, char *output_typ)
{
   char permissions[11];
   char size[10];
   char month_day[7];
   char year[5];
   char str1[1024];
   char location[1024];
   char location_old[1024];
   char *fname;
   extern int new;
   extern int debug;

   /* extract line */
   strncpy(permissions, line+1, 10);
   permissions[10]=0;
   strncpy(size, line+24, 9);
   size[9]=0;
   strncpy(month_day, line+38, 6);
   month_day[6]=0;
   strncpy(year, line+54, 4);
   year[4]=0;
   strncpy(str1, line+59, 255);
   str1[strlen(line)-59]=0;

   /* extract filename */
   fname=strrchr(str1, '/')+1;
   /* strip '\n' */
   fname[strlen(fname)-1]=0;

   strcpy(location_old, location);
   sprintf(location, "/%s", str1);
   location[strlen(str1)-strlen(fname)]=0;

   /* check for unwanted path and file */
   if( (check_entry_filename(fname)) && 
      (check_entry_exact_pathname(location)) &&
      (check_entry_recursive_pathname(location)) ) {
   
      new++;

      /* the first time we have a new file to announce 	*/
      /* set the corresponding stream          		*/
      if(new == 1)
         if( !strcmp(output_typ, "p") ) { /* post */
            open_inews();
         } else if( !strcmp(output_typ, "m") ) { /* mail */
            open_mail();
         } else if( (out = fopen("/dev/stdout","r+")) == NULL ) {
            error_log("can not open /dev/stdout","");
            exit(1);
         }

      /* new location ? */
      if (strcmp(location, location_old) != 0)
         fprintf(out, "\n    Location: %s\n", location);

      /* file or directory ? */
      if (line[1] == '-') {
         fprintf(out, "           FILE ");
      } else {
         fprintf(out, "      DIRECTORY ");
      }

      /* all done, print it */
      fprintf(out, " %s %s  %s %s ", permissions, size, month_day, year);
      fprintf(out, "%s\n", fname);
   } else {
      if(debug)
         fprintf(stderr, "DEBUG: excluding %s\n", str1);
   }
}

