/* $Id: notify_new.c,v 1.1 1999/03/27 14:18:33 dg8xt Exp $ */

/*
 * NOTITY_NEW is Copyright (C) 1999 by Thomas Weinell <kf6mli@amsat.org>
 *
 * NOTITY_NEW is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; version 2 dated June, 1991
 *
 * NOTITY_NEW is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with NOTITY_NEW; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>
#include <unistd.h>
#include "log.h"
#include "mail.h"
#include "parse_input.h"
#include "post.h"
#include "read_config.h"

int debug=0;
int new=0;

int main(int argc, char *argv[])
{
   
   FILE *in;
   char conf_file[255]="";
   char line[255];
   char output_typ[2]="";
   extern char *optarg;
   extern int opterr;
   int opt;
   
   opterr=0;

   /* scan the command line on options */
   while ((opt=getopt(argc, argv, "c:dpm")) > 0) {
      switch (opt) {
         case 'c': strcpy(conf_file, optarg);
            	   break;
         case 'd': debug++;
            	   break;
         case 'p': strcpy(output_typ, "p");
            	   break;
         case 'm': strcpy(output_typ, "m");
            	   break;
         default : printf("Usage: %s [-d] [-c <config-file>] [-p] [-m]\n", argv[0]);
            	   exit(1);
                   break;
      }
   }

   read_config(conf_file);

   if( (in = fopen("/dev/stdin","r")) == NULL ) {
      error_log("can not open /dev/stdin","");
      return 1;
   }

   while( fgets(line, 255, in) != NULL) {
      if(line[0]=='+')
         parse_input(line, output_typ);
   }

   if( !strcmp(output_typ, "p") )
      close_inews();
   if( !strcmp(output_typ, "m") )
      close_mail();
   fclose(in);
   return 0;
}

