/* $Id: mail.c,v 1.1 1999/03/27 14:18:33 dg8xt Exp $ */

#include <stdio.h>
#include "global.h"
#include "log.h"
#include "mail.h"
#include "parse_input.h"


/* -------------------------------------------------------------------- */
/* open pipe to sendmail						*/
/* return: none 							*/
/* -------------------------------------------------------------------- */

void open_mail()
{
   char send_mail[1024];

#ifndef HAVE_SENDMAIL
   error_log("no sendmail defined. mailing disabled");
   exit(-1);
#endif

   sprintf(send_mail, "%s -oi -f%s %s\n", SENDMAIL_PROG, FROM, MAIL_TO);

   if((out = popen(send_mail, "w")) == NULL) {
      error_log("Unable to open pipe to sendmail", send_mail);
      exit(-1);
   }

   fprintf(out, "To: %s\n", MAIL_TO);
   fprintf(out, "Subject: %s\n", SUBJECT);
   fprintf(out, "\n");
}


/* -------------------------------------------------------------------- */
/* close pipe to sendmail						*/
/* return: none								*/
/* -------------------------------------------------------------------- */

void close_mail(void)
{
   fprintf(out, "\n");
   if( (pclose(out)) != 0 ) {
      /* done this because popen will not return NULL,
         if /bin/sh could not execute sendmail */
      error_log("unable to close pipe to sendmail","");
   }
}

