#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "filename.h"
#include "log.h"

/* ------------------------------------------------------------ */
/* add an entry to struct					*/
/* return:  0 on success, 1 if false				*/
/* ------------------------------------------------------------ */

int add_entry_filename(char *fname)
{
   struct filename *p;

   /* allocate memory for new entry */
   p = (struct filename *) malloc(sizeof(struct filename));
   if (!p) {
      error_log("can not malloc struct exact_pathname","");
      return 1;
   }
   
   /* add entry */
   strcpy(p->name, fname);
   p->next = Filename;
   Filename = p;
   
   return 0;
}                                 
   

/* ------------------------------------------------------------ */
/* do we have an entry ?					*/
/* return: TRUE = 0  FALSE = 1 					*/
/* ------------------------------------------------------------ */

int check_entry_filename(char *search_string)
{
   struct filename *p;
   for (p = Filename; p; p = p->next)
      if( !strcmp(p->name, search_string) ) return 0;
   return 1;
}

