#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "exact_path.h"
#include "log.h"


/* ------------------------------------------------------------ */
/* add an entry to struct					*/
/* return:  0 on success, 1 if false				*/
/* ------------------------------------------------------------ */

int add_entry_exact_pathname(char *string)
{
   struct exact_pathname *p;

   /* allocate memory for new entry */
   p = (struct exact_pathname *) malloc(sizeof(struct exact_pathname));
   if (!p) {
      error_log("can not malloc struct exact_pathname","");
      return 1;
   }
   
   /* add entry */
   strcpy(p->name, string);
   p->next = Exact_pathname;
   Exact_pathname = p;
   
   return 0;
}                                 
   

/* ------------------------------------------------------------ */
/* do we have an entry ?					*/
/* return: TRUE = 0  FALSE = 1 					*/
/* ------------------------------------------------------------ */

int check_entry_exact_pathname(char *search_string)
{
   struct exact_pathname *p;
   for (p = Exact_pathname; p; p = p->next)
      if( !strcmp(p->name, search_string) ) return 0;
   return 1;
}

