#!/usr/local/bin/perl -- -*-perl-*-

# ------------------------------------------------------------
# Form-mail.pl, by Reuven M. Lerner (reuven@the-tech.mit.edu).
#
# Last updated: March 14, 1994
#
# Form-mail provides a mechanism by which users of a World-
# Wide Web browser may submit comments to the webmasters
# (or anyone else) at a site.  It should be compatible with
# any CGI-compatible HTTP server.
# 
# Please read the README file that came with this distribution
# for further details.
# ------------------------------------------------------------

# ------------------------------------------------------------
# This package is Copyright 1994 by The Tech. 

# Form-mail is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any
# later version.

# Form-mail is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Form-mail; see the file COPYING.  If not, write to the Free
# Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
# ------------------------------------------------------------

# ------------------------------------------------------------
# This Package further modified by Sean Utt to allow for multiple               
# mailto: entries, allowing for a checkbox mailer, and generic                  
# use by all persons on the system for forms based mail..                       
# included with this should be sample .html files for a mass listing            
# and for idividual use.                                                        
#                                                                               
# Also, there should be perl scripts to maintain those files.                   
# A packing list will be included here later..                                  
#                                                                               
# This version also modified to allow generic surveys to send mail                   
# Later I may open local files instead.   For that version, see                 
# survey-mail-form.pl                                                                              
#                                                                               
#                                                                               
#                                                                               
#                                                                               
# ------------------------------------------------------------


# Define fairly-constants

# This should match the mail program on your system.
$mailprog = '/usr/lib/sendmail';

# I am setting this up so that this can use a check box to send to as many 
# people as a person selects on the html page feeding it.
# also is a generic interface for anyone on the system...


# Print out a content-type for HTTP/1.0 compatibility
print "Content-type: text/html\n\n";

# Print a title and initial heading
print "<Head><Title>Thank you</Title></Head>";
print "<Body><H1>Thank you</H1>";

# Get the input
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
#print "$buffer<P>\n";  #DEBUG LINE
# Split the name-value pairs
    $counter=0;
@pairs = split(/&/, $buffer);
foreach $pair (@pairs)
{
    ($name, $value) = split(/=/, $pair);
    # Un-Webify plus signs and %-encoding
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

    # Stop people from using subshells to execute commands
    # Not a big deal when using sendmail, but very important
    # when using UCB mail (aka mailx).
    # $value =~ s/~!/ ~!/g; 

    # Uncomment for debugging purposes
#     print "Setting $name to $value<P>";  #DEBUG LINE
    $FORM[$counter] = $value;
    $counter++;
}
$counter = ($counter -1);
#print "$counter<P>";  #DEBUG LINE

# assign all the $FORM[] entries to mailable values
# You need to set up this directory to keep survey results in and send the
# name to this script, make it an absolute path.

$mailto=$FORM[$counter - 4];
#print " mailto $mailto<P>"; #DEBUG LINE
$HomePage=$FORM[$counter - 3];
#print " HomePage $HomePage<P>"; #DEBUG LINE
$username=$FORM[$counter - 2];
#print " username $username<P>"; #DEBUG LINE
$realname=$FORM[$counter - 1];
#print " realname $realname<P>"; #DEBUG LINE
$HomeFront=$FORM[$counter];
#print " HomeFront $HomeFront<P>"; #DEBUG LINE
#$Survey="PlugSurvey";
#print " SurveyFileName $Survey<P>"; #DEBUG LINE
# If the comments are blank, then give a "blank form" response
#&blank_response unless $username;
#&blank_response unless $realname;
# Now send mail to $mailto
open (MAIL, "|$mailprog $mailto") || die "Can't open $mailprog!\n";
print MAIL "Reply-to: $username $realname\n";
print MAIL "Subject: Mail from the web  (Survey Results)\n\n";
print MAIL "$username ( $realname )sent the following\n";
print MAIL  "------------------------------------------------------------\n";
foreach $i (0 ... ($counter - 5)) {
print MAIL "--->$FORM[$i]\n";
}
#print MAIL "\n------------------------------------------------------------\n";
#close (MAIL);

# And the same thing in the $SurveyDir


#open (SURVEYFILE, ">>$Survey") || die "Can't open $SurveyFileName!\n";
#print SURVEYFILE " $username $realname\n";
#print SURVEYFILE  "------------------------------------------------------------\n";
#print SURVEYFILE "$FORM[0]";
#foreach $i (1 ... ($counter - 6)) {
#print SURVEYFILE ":$FORM[$i]";
#}
#print SURVEYFILE "\n------------------------------------------------------------\n";
#close (SURVEYFILE);
#

# Make the person feel good for writing to us
print "Thank you for flying <I>Shoostring.com</I>!<P>";
print "Return to our <A HREF=\"$HomePage\">home page</A>, if you want.<P>";

# ------------------------------------------------------------
# subroutine blank_response
sub blank_response
{
    print "Your choices email address, or name, appear to be blank, and thus were not sent ";
    print "Please <A HREF=\"$HomeFront\">re-enter</A> your choices, or ";
    print "return to our <A HREF=\"$HomePage\">home page</A>, if you want.<P>";
    exit;
}
