/*
 * This is the source-code to IROs, written by Rob Vanderhoff.  It is the
 * server which runs on a host and creates html documents describing whether
 * the owner is online or off.  This is so that people with dynamically
 * allocated IP addresses can still have a webserver on their home computer.
 * This source is, of course, Copyright (c) Rob Vanderhoff.
 * I (Rob Vanderhoff) am not responsible for any damage this program may
 * cause.  It is distributed without any warranty of any kind, neither
 * expressed, nor implied.  Just by LOOKING at this source, you are
 * concurring your acceptance to these terms.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <string.h>

/*****************GLOBAL VARS**************************/

#define VERSION "1.0"
#define orig_fname "iros.html"

extern int errno;
int flength;
char hostname[64];
struct hostent *hp, *hp2;
char *html_fname, *myname;
int Port = 4417;

/*****************PROTOTYPES***************************/

void open_message(void);
void help_message(void);
void parse_args(int acount, char *avar[]);
void make_html_file(char *ad, char *na);
void gone_html_file(void);

/*****************MAIN PROC****************************/

void main(int argc, char *argv[]) {
   
   register int s, ns;
   struct sockaddr_in sin, nsin;
   char *addr, *hname;
   char in_string[256];
   FILE *fil;
   
   myname = argv[0];
   open_message();
   html_fname = orig_fname;
   
   if (argc > 1)
     parse_args(argc, argv);
   
   /* Fork off into background */
   
   if (fork()) {
      exit(0);
   }
   
   /* Get our hostname */
   
   gethostname(hostname, sizeof(hostname));
   
   /* Lookup IP address */
   
   if ((hp = gethostbyname(hostname)) == NULL) {
      fprintf(stderr, "iros: %s: host unknown.\n",hostname);
      exit(1);
   }
   
   /* Get a socket */
   
   if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      perror("iros: socket");
      exit(1);
   }
   
   /* Setup address structure */
   
   bzero((void *) &sin, sizeof(sin));
   sin.sin_family = AF_INET;
   sin.sin_port = htons(Port);
   bcopy(hp->h_addr, &sin.sin_addr, hp->h_length);

   /* Bind the address to the socket */
   
   if (bind(s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
      perror("iros: bind");
      exit(1);
   }
   
   /* Listen on the socket */
   
   if (listen(s, 5) < 0) {
      perror("iros: listen");
      exit(1);
   }
   
   /* Accept connections */
   
   for (;;) {
      bzero((void *) &nsin, sizeof(nsin));
      flength = sizeof(struct sockaddr_in);
      if ((ns = accept(s, (struct sockaddr *) &nsin, &flength)) < 0) {
	 perror("iros: accept");
	 exit(1);
      }
      
      addr = (char *) inet_ntoa(nsin.sin_addr);
      if ((hp2 = gethostbyaddr((char *)&nsin.sin_addr.s_addr, sizeof(long),
			       AF_INET)) == NULL) {
	 fprintf(stderr,"iros: error getting connected host's address!\n");
      }
      else {
	 hname = hp2->h_name;
      }
      
      fil = fdopen(ns, "r");
      fscanf(fil, "%s", in_string);
      if (strcmp(in_string, "HELLO") == 0) {
	 make_html_file(addr, hname);
      }
      else if (strcmp(in_string, "SEEYA") == 0) {
	 gone_html_file();
      }
      else {
	 write(ns, "Unauthorized Access!\n", 21);
      }
      fclose(fil);
      shutdown(ns, 2);
   }
   
   /************SHUTDOWN MAIN SOCKET...ETC..****************/
   
   shutdown(s, 2);
};

/*****************PROCEDURE BODIES*********************/

void open_message(void) {
   printf("\n");
   printf("IROs Version %s by Rob Vanderhoff.\n",VERSION);
   printf("Copyright (c) 1996.\n");
   printf("Type '%s -h' for help.\n",myname);
   printf("\n");
};

void help_message(void) {
   printf("usage: %s [switches [arguments]]\n",myname);
   printf("\n");
   printf("-h               Print this information.\n");
   printf("-p <port>        Make IROs use <port> instead of\n");
   printf("                 the default (%d).\n",Port);
   printf("-f <file>        Make IROs use the filename <file>\n");
   printf("                 when writing the html code instead\n");
   printf("                 of the default (%s).\n",html_fname);
   printf("\n");
};

void parse_args(int acount, char *avar[]) {
   char *arg;
   int i;
   
   while ((acount > 1) && (avar[1][0] == '-')) {
      acount--;
      arg = *++avar;
      
      switch (arg[1]) {
       case 'h':
	 help_message();
	 exit(0);
	 break;
       case 'p':
	 ++avar;
	 acount--;
	 if (*avar && (Port = atoi(*avar)))
	     printf("Port set to %d\n", atoi(*avar));
	 else {
	    printf("Invalid port value, ya retard!\n");
	    exit(1);
	 }
	 break;
       case 'f':
	 ++avar;
	 acount--;
	 if (!*avar) {
	    printf("No html file specified, ya moron!\n");
	    exit(1);
	 }
	 (char *) html_fname = *avar;
	 printf("Filename set to '%s'\n",*avar);
	 break;
       default:
	 printf("Unknown option: %s\n",arg);
	 exit(1);
	 break;
      }
   }
};
   
void make_html_file(char *ad, char *na) {
   FILE *fp;
   
   if ((fp = fopen(html_fname, "w")) == NULL) {
      fprintf(stderr, "iros: Error opening html file!\n");
   }
   else {
      fprintf(fp, "<HTML>\n");
      fprintf(fp, "<HEAD>\n");
      fprintf(fp, "<TITLE>IROS</TITLE>\n");
      fprintf(fp, "</HEAD>\n");
      fprintf(fp, "\n");
      fprintf(fp, "<BODY>\n");
      fprintf(fp, "<H2>I am currently online:<H2>\n");
      fprintf(fp, "<BR>\n");
      fprintf(fp, "<PRE>\n");
      fprintf(fp, "IP Address   : %s\n",ad);
      fprintf(fp, "Name-Address : %s\n",na);
      fprintf(fp, "</PRE>\n");
      fprintf(fp, "<BR>\n");
      fprintf(fp, "<P>\n");
      fprintf(fp, "If my home-webserver is working, it can be ");
      fprintf(fp, "reached by \n");
      fprintf(fp, "<A HREF=\"http://%s\">clicking here</A>.\n",na);
      fprintf(fp, "</P>\n");
      fprintf(fp, "</BODY>\n");
      fprintf(fp, "</HTML>\n");
      fclose(fp);
   }
};

void gone_html_file(void) {
   FILE *fp;
   
   if ((fp = fopen(html_fname, "w")) == NULL) {
      fprintf(stderr, "iros: Error opening html file!\n");
   }
   else {
      fprintf(fp, "<HTML>\n");
      fprintf(fp, "<HEAD>\n");
      fprintf(fp, "<TITLE>IROS</TITLE>\n");
      fprintf(fp, "</HEAD>\n");
      fprintf(fp, "<BR>\n");
      fprintf(fp, "<BODY>\n");
      fprintf(fp, "<H2>I am not currently online.<H2>\n");
      fprintf(fp, "</BODY>\n");
      fprintf(fp, "</HTML>\n");
      
      fclose(fp);
   }
};

