/*
 * This is the source-code to IROc.  It is the client program that interacts
 * with the IROs server, and tells it whether you are online or offline, 
 * according to the command-line parameters.
 * 
 * Just by reading this source-code, you agree to the acceptance of the terms
 * expressed at the beginning of 'iros.c', which also apply to this file.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>

/*****************GLOBAL VARS**************************/

#define VERSION "1.0"

char ONOFF[5] = "HELLO";
int Port = 4417;
char *myname;

/*****************PROTOTYPES***************************/

void open_message(void);
void help_message(void);
void parse_args(int acount, char *avar[]);

/*****************MAIN PROC****************************/

void main(int argc, char *argv[]) {
   
   char *hostname;
   register int s;
   struct hostent *hp;
   struct sockaddr_in sin;
   
   myname = argv[0];
   open_message();
   
   if (argc < 2) {
      help_message();
      exit(1);
   }
   parse_args(argc, argv);
   
   hostname = argv[argc-1];
   
   /* Lookup IP Address of specified host */
   
   printf("Looking up %s...\n",hostname);
   if ((hp = gethostbyname(hostname)) == NULL) {
      fprintf(stderr, "iroc: %s: unknown host.\n",hostname);
      exit(1);
   }
   
   /* Get a socket to use */
   
   if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      perror("iroc: socket");
      exit(1);
   }
   
   /* Create the address we're gonna hook to */
   
   bzero((void *) &sin, sizeof(sin));
   sin.sin_family = AF_INET;
   sin.sin_port = htons(Port);
   bcopy(hp->h_addr, &sin.sin_addr, hp->h_length);
   
   /* Try to connect to the address */
   
   printf("Connecting to %s\n",inet_ntoa(sin.sin_addr));
   if (connect(s, (struct sockaddr *) &sin, sizeof(sin)) < 0) {
      perror("iroc: connect");
      exit(1);
   }
   
   /*Tell IROs whether we're on or off.. */
   
   if (strcmp(ONOFF, "HELLO") == 0) {
      printf("Telling IROs we're online, and what our address is...\n");
   }
   else {
      printf("Telling IROs we're going offline...\n");
   }
    
   write(s, ONOFF, 5);
   shutdown(s, 2);
   printf("Connection closed.\n");
   
};

/*****************PROCEDURE BODIES*********************/

void open_message(void) {
   printf("\n");
   printf("IROc Version %s by Rob Vanderhoff.\n",VERSION);
   printf("Copyright (c) 1996.\n");
   printf("Type '%s -h' for help.\n",myname);
   printf("\n");
};

void help_message(void) {
   printf("usage: [switches [arguments]] <server>\n",myname);
   printf("\n");
   printf("<server>         The server IROs is running on.\n");
   printf("-h               Print this information.\n");
   printf("-o               Tell IROs you're going offline,\n");
   printf("                 otherwise IROc tells IROs you're on.\n");
   printf("-p <port>        Specify the port to use when communicating\n");
   printf("                 with IROs, if different from the\n");
   printf("                 default (%d).\n",Port);
   printf("\n");
};

void parse_args(int acount, char *avar[]) {
   char *arg;
   int i;
   
   while ((acount > 1) && (avar[1][0] == '-')) {
      acount--;
      arg = *++avar;
      
      switch (arg[1]) {
       case 'h':
	 help_message();
	 exit(0);
	 break;
       case 'p':
	 ++avar;
	 acount--;
	 if (*avar && (Port = atoi(*avar)))
	   printf("Port set to %d\n",atoi(*avar));
	 else {
	    printf("Invalid port value, ya snuckbucket!\n");
	    exit(1);
	 }
	 break;
       case 'o':
	 strcpy(ONOFF, "SEEYA");
         break;
       default:
	 printf("Unknown option %s\n",arg);
	 exit(1);
	 break;
      }
   }
};
       


