#include <ctype.h>
#include <endian.h>
#include <getopt.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include "common.h"

int                      getToken(char *d, char *s, int *idx);
void                     usage();
void                     errQuit(char *format,...);
void                     perrQuit(char *name);

void
main(int argc, char **argv)
{
  int                      i,
                           fd;
  char                     server[64] = "",
                           line[256];
  FILE                    *f;
  struct hostent          *hp;
  struct sockaddr_in       addr;

  while ((i = getopt(argc, argv, "ps")) != EOF) {
    switch (i) {
    case 'p':
      port = atoi(argv[optind++]);
      break;
    case 's':
      strcpy(server, argv[optind++]);
      break;
    default:
      errQuit("Unknown switch: %c", (char) i);
    }
  }
  if (optind + 2 > argc)
    usage();
  if (server[0] == '\0')
    errQuit("Server not specified.");

  if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    perrQuit("socket");
  hp = gethostbyname(server);
  if (!hp)
    errQuit("Invalid server: %s", server);

  bzero(&addr, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_port = htons(port);
  memcpy(&addr.sin_addr, hp->h_addr, hp->h_length);
  if (connect(fd, (struct sockaddr *) &addr, sizeof(addr)) < 0)
    perrQuit("connect");

  f = fdopen(fd, "r+");
  if (toupper(argv[optind][0]) == 'A') {
    if (optind + 5 > argc)
      usage();
    strcpy(line, "ADD");
  } else if (toupper(argv[optind][0]) == 'R') {
    if (optind + 3 > argc)
      usage();
    strcpy(line, "REMOVE");
  } else if (toupper(argv[optind][0]) == 'S') {
    strcpy(line, "SEARCH");
  } else
    usage();
  while (++optind < argc)
    sprintf(line + strlen(line), " %s", argv[optind]);
  fprintf(f, "%s\n", line);
  fgets(line, 256, f);
  if (!strcmp(line, "Syntax error.\n"))
    usage();
  if (strcmp(line, "OK\n"))
    printf(line);
  fclose(f);
}

int
getToken(char *d, char *s, int *idx)
{
  int                      si,
                           di,
                           slen = strlen(s);

  for (si = *idx; si < slen && isspace(s[si]); si++);
  for (di = 0; si < slen && isgraph(s[si]); si++)
    d[di++] = s[si];
  d[di] = '\0';
  *idx = si;
  return di == 0;
}

void
usage()
{
  errQuit("Usage: ipfn -s <server> [-p <port>] <request>\n"
	  "       <request> ::= A[dd] <passwd> <hours> <host> <name>\n"
	  "                  |  R[emove] <passwd> <name>\n"
	  "                  |  S[earch] <name>");
}

void
errQuit(char *format,...)
{
  char                     buf[256];
  va_list                  ap;

  va_start(ap, format);
  vsprintf(buf, format, ap);
  printf("%s\n", buf);
  exit(1);
}

void
perrQuit(char *name)
{
  perror(name);
  exit(1);
}
