#ifndef HASH_H
#define HASH_H

#include "types.h"

typedef word               (*HashFn)(word size, void *key);
	
typedef struct HashTableListNode {
  void				*item;
  struct HashTableListNode	*next;
} HashTableListNode;

typedef struct HashTable {
  word                     size;
  word                     nItems;
  HashTableListNode      **table;
  HashFn                   hashFn;
  CompFn                   compFn;
  word                     keyOffset;
  Boolean                  ownsItems;
  word                     iterationList;
  HashTableListNode       *curNode;
} HashTable;

void                     hashTableInit(HashTable *hTable, word size, HashFn hashFn,
				       CompFn compFn, word keyOffset, Boolean ownsItems);
void                     hashTableDeinit(HashTable *hTable);
word                     hashTableNitems();
void                     hashTableIterateInit(HashTable *hTable);
void                    *hashTableIterate(HashTable *hTable);
void                     hashTableIterateDeinit(HashTable *hTable);
void                     hashTableAdd(HashTable *hTable, void *item);
int                      hashTableDel(HashTable *hTable, void *key);
void                    *hashTableSearch(HashTable *hTable, void *key);
void                    *hashTableSearchNext(HashTable *hTable, void *key);

#endif
