#include "fhostd.h"

/*************************************************************
 *                                                           *
 *  This file contains the following routines:               *
 *                                                           *
 *  send_mail() sends a mail message.                        *
 *  finger_host() fingers the remote host and sends the      *
 *  results through the mail. Finally, map_host() runs       *
 *  nmap against the remote host and sends the results       *
 *  through the mail.                                        *
 *                                                           *
 *************************************************************/

int send_mail (char *subject, char *mess)
{
	int pipefds[2];
	pid_t pid;

	/* Spawn a child to send mail. */

        switch (fork()) {
        case -1:
          log_err (use_syslog, P_ERROR, "send_mail: fork1");
          /* NOTREACHED */
        case 0:
          break;	/* The child lives on */
	default:
	  return 0;	/* The parent returns */
        }

	/* The child reopens stdin, stdout, and stderr */

	dup(0); dup(1); dup(2);

	/* The child and grandchild do the work. */

	if (pipe(pipefds) < 0)
	  log_err (use_syslog, P_ERROR, "send_mail: pipe");

	/* Fork a grandchild to exec Mail. */

	switch (pid = fork()) {
	case -1:
	  log_err (use_syslog, P_ERROR, "send_mail: fork2");
	  /* NOTREACHED */

	case 0:  /* The grandchild execs Mail and listens */
	  dup2(pipefds[0],0);
	  close(pipefds[0]);
	  close(pipefds[1]);

	  execl(MPATH, "Mail","-n", "-s",
	    subject, MAIL_AD, (char *) 0);

	  log_err (use_syslog, P_ERROR, "send_mail: execl");
	  /* NOTREACHED */

	default: /* The child sends the message */
	  dup2(pipefds[1],1);
	  dup2(pipefds[1],2);
	  close(pipefds[0]);
	  close(pipefds[1]);

	  printf("%s",mess);

	  exit (0); /* Exit so stdout and stderr will flush. */
	}
}

int finger_host (char *local, char *host)
{
	int pipefds[2];
	pid_t pid;

	/* Spawn a child to finger the host. */

	switch (fork()) {
	case -1:
	  log_err (use_syslog, P_ERROR, "finger_host: fork1");
	  /* NOTREACHED */
	case 0:
	  break;		/* The child continues */
	default:
	  return 0;		/* The parent returns */
	}

	/* The child reopens stdin, stdout, and stderr */

	dup(0); dup(1); dup(2);

	/* The child is responsible for fingering the host. */

	if (pipe(pipefds) < 0)
	  log_err (use_syslog, P_ERROR, "finger_host: pipe");

 	/* Spawn another child to do the work. */

	switch (pid = fork()) {

	case -1:

	  log_err (use_syslog, P_ERROR, "finger_host: fork2");

	  /* NOTREACHED */

	case 0:  /* The grandchild execs Mail and listens. */

	  dup2(pipefds[0],0);
	  close(pipefds[0]);
	  close(pipefds[1]);

	  execl(MPATH, "Mail","-n", "-s",
	     "Finger Host", MAIL_AD, (char *) 0);

	  log_err (use_syslog, P_ERROR, "finger_host: execl(Mail)");

	/* NOTREACHED */

	default:  /* The child execs safe_finger and writes to the pipe. */

	  dup2(pipefds[1],1);
	  dup2(pipefds[1],2);
	  close(pipefds[0]);
	  close(pipefds[1]);

	  execl(FPATH, "safe_finger", "-l", host, (char *) 0);

	  log_err (use_syslog, P_ERROR, "finger_host: execl(safe_finger)");

	/* NOTREACHED */

	} /* end switch */
}

int map_host(char *local, char *host, int r00t_flag)
{
	int pipefds[2];
	pid_t pid;
        char *phost;

        phost = (char*)(host+1); /* Get rid of the @ character */

	/* Spawn a child to map the host. */

	switch (fork()) {
	case -1:
	  log_err (use_syslog, P_ERROR, "map_host: fork1");
	  /* NOTREACHED */
	case 0:
	  break;		/* The child continues */
	default:
	  return 0;		/* The parent returns */
	}

	/* The child reopens stdin, stdout, and stderr */

	dup(0); dup(1); dup(2);

	/* The child is responsible for mapping the host. */

	if (pipe(pipefds) < 0)
	  log_err (use_syslog, P_ERROR, "map_host: pipe");

	switch (pid = fork()) { /* Spawn children to do the work. */

	case -1:

	  log_err (use_syslog, P_ERROR, "map_host: fork2");

	/* NOTREACHED */

	case 0: /* The grandchild execs Mail and listens. */

	  dup2(pipefds[0],0);
	  close(pipefds[0]);
	  close(pipefds[1]);

	  execl(MPATH, "Mail","-n", "-s",
	     "Remote Host Port Map", MAIL_AD, (char *) 0);

	  log_err (use_syslog, P_ERROR, "map_host: execl(Mail)");

	/* NOTREACHED */

	default: /* The child execs nmap and writes to the pipe. */

	  dup2(pipefds[1],1);
	  dup2(pipefds[1],2);
	  close(pipefds[0]);
	  close(pipefds[1]);

	  if (r00t_flag)  /* If we are r00t, then be aggressive! */
	    execl(MAPATH, "nmap", "-sS", "-O", phost, (char *) 0);
	  else            /* If we are not r00t, then be less aggressive. */
	    execl(MAPATH, "nmap", "-v", phost, (char *) 0);

	  log_err (use_syslog, P_ERROR, "map_host: execl(nmap)");

	/* NOTREACHED */

	} /* end switch */
}
