#include <syslog.h>
#include <errno.h>

/**********************************************************
 *                                                        *
 *     Log errors either to syslog or to stdout.          *
 *     P_ERROR is considered a fatal error so we exit(1). *
 *     SYS_LOG errors are logged then we return.          *
 *     default errors are fatal.                          *
 *                                                        *
 **********************************************************/

#define P_ERROR 1
#define SYS_LOG 2

void log_err (int use_syslog, int log_type, char *mess)
{
  char err_mess[512];

  switch (log_type) {
  case SYS_LOG:
    if (use_syslog)
      syslog (LOG_ERR, mess);
    else
      printf("fhostd: %s\n", mess);
    return;		/* SYS_LOG returns */
  case P_ERROR:
    if (use_syslog) {
      strcpy(err_mess, mess);
      strcat(err_mess, ": ");
      strcat(err_mess, strerror(errno));
      syslog(LOG_ERR, err_mess);
    } else {
      strcpy(err_mess, "fhostd: ");
      strcat(err_mess, mess);
      perror(err_mess);
    }
    exit (1);		/* P_ERROR is fatal */
  default:
    if (!use_syslog)
      openlog ("fhostd", LOG_CONS | LOG_NDELAY | LOG_PID, LOG_DAEMON);
    syslog(LOG_ERR,"Unknown log_type follows:");
    syslog(LOG_ERR, mess);
    exit(1);		/* default is fatal */
  }
  /* NOTREACHED */
}
