/*********************************************************************
 *                                                                   *
 *                      fhostd.h include file                        *
 *                                                                   *
 *  It is not necessary to modify any defines here; the defines are  *
 *  set using the user modified include file "defines.h".            *
 *                                                                   *
 *********************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/time.h>
#include <sys/wait.h>

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <errno.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <syslog.h>

#include "defines.h"  /* User modified include file */

#define ADDRESS		PATH_TO_UNIX_SOCKET
#define MAIL_AD		ADDRESS_FOR_MAIL
#define MHOSTS		HOST_TABLE_SIZE
#define MPATH		PATH_TO_MAIL
#define FPATH		PATH_TO_SAFE_FINGER
#define MAPATH		PATH_TO_NMAP
#define PIDPATH		PATH_TO_PID

#define P_ERROR	 1
#define SYS_LOG	 2

#define MAXCHARS	MAX_CHARS_HOSTNAME
#define MAXMESS		MAX_CHARS_MESSAGE

static long time_out = FHOSTD_TIMEOUT;

int use_syslog;		   	   /* Syslog logging flag. */

#if defined(FHOST_NET)		/* FhostNET defines */

#include <netinet/in.h>
#include <arpa/inet.h>

#define SERV_PORT	FHOSTD_NET_PORT
#define LOCALHOST	FHOSTD_NET_HOST

struct event_table {	/* Network event table */
	char	*local;
	char	*name;
	char	*service;
	int	hits;
};

#elif defined(FHOST_UNIX)		/* FhostdUNIX defines */

#define LOCALHOST	FHOSTD_UNIX_HOST

struct event_table {	/* UNIX event table */
	char	*name;
	char	*service;
	int	hits;
};

#endif

typedef struct event_table table_ev;

table_ev *table[MHOSTS];  /* Host table */
int itab, itabf;          /* Table index and loop around flag */

int reap_children(void);
void *reap_child(int);
int sighup_setup(void);
void *dump_table(int);
void block_sigchld(void);
void unblock_sigchld(void);
int finger_host(char*,char *);
int map_host(char*,char *,int);
int send_mail(char*,char*);
int daemon_init(void);
void log_err (int,int,char*);
void print_usage (int);
