/*
	This is the unix domain finger host client. It simply
	reads in the remote host name and the requested service
	and tries to send it to the server program via a socket.
	If it can't open a socket to the server it transforms
	itself into the server by doing an exec system call.
	We use a unix domain socket here as the client and
	server are running on the same host.

    Copyright (C) 1996 <Ed Alley, Email: wea@llnl.gov>

*/

#include "fhost.h"

main(argc, argv)
int argc;
char **argv;
{
	char c;
	char localhost[MAXCHARS], host[MAXCHARS], service[MAXCHARS];
	char mess[MAXMESS];
	int i, j, s, len, nbr, cl, use_nmap, use_syslog;
	struct sockaddr_un saun;
	extern char *optarg;
	extern int opterr, optind, optopt;

	openlog ("fhost", LOG_CONS | LOG_NDELAY | LOG_PID, LOG_DAEMON);

	/*
	  Number of arguments is less than five.
	*/

	if (argc > 4) {
	  syslog (LOG_ERR, "Too many arguments!\n");
	  syslog (LOG_ERR, "For usage enter the command: fhost -h\n");
	  exit (1);
	}

	/*
	  Check argument lengths (must be less than MAXCHARS-1).
	*/

	j = 0;
	for (i=0; i<argc; i++) {
	 if (strlen(argv[i]) > MAXCHARS-1) {
	  j = 1;
	  syslog(LOG_ERR,"Argument length exceeded. ...Exiting\n");
	  syslog(LOG_ERR,"%.32s: Possible buffer overrun attack.\n",
		 argv[i]);
	 }
	}

	if (j) {
	  syslog (LOG_ERR, "Fhost: For usage enter the command: fhost -h\n");
	  exit (1);
	}

	/* Process the command line options. */

	use_nmap   = 0;
	use_syslog = 1;

	while ((cl = getopt(argc, argv, "hnsv")) != -1) {
          switch (cl) {
	    case 's':
	      use_syslog = 0;
	      break;
	    case 'n':
	      use_nmap = 1;
	      break;
	    case 'v':
	      printf("Fhost version number: "VERSION"\n");
	      exit (0);
	    case 'h':
	    default:
	      print_usage (0);
          }
        }

	if (argc-optind < 2) {
	  syslog(LOG_ERR, "Incorrect number of arguments!\n");
	  syslog(LOG_ERR, "For usage enter the command: fhost -h\n");
	  exit (1);
	}

	/*
	  Check to see if we have a host name.
	*/

	if (argv[optind][0] != '@') {
	  syslog(LOG_ERR, "Hostname error: %s\n", argv[optind]);
	  syslog(LOG_ERR, "For usage enter the command: fhost -h\n");
	  exit (1);
	}

	/*
	  Place arguments into the appropriate arrays.
	*/

	i = 0;
	while ((c = argv[optind][i]) != '\0')
	  host[i++] = c;

	host[i]   = '\0';

	i = 0;
	while ((c = argv[optind+1][i]) != '\0')
		service[i++] = c;

	service[i] = '\0';

	strcpy (localhost, LOCALHOST);

	/*
	  Get a UNIX domain stream socket.
	*/

	if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) < 0)
	  log_err (use_syslog, P_ERROR, "fhost: socket");

	/*
	  Store the address info into the socket structure.
	*/

	bzero((char *) &saun, sizeof(saun));

	saun.sun_family = AF_UNIX;
	strcpy(saun.sun_path, ADDRESS);

	/*
	  Try to connect to the socket. For this to work,
	  the server must already have bound this address,
	  and must have issued a listen() request.

	  The third argument indicates the "length" of the
	  structure, and not just the length of the socket
	  name.

	  If we cannot connect to a server then we assume
	  that this is a new event. In that case we exec
	  the server.
	*/

	if (connect(s, (struct sockaddr *) &saun, sizeof(saun)) < 0) {

	    close(s);    /* We don't need the socket anymore. */

	    closelog();

	    if (use_nmap)
		execl(SPATH, SNAME , "-n", host, service, (char *) 0);
	    else
		execl(SPATH, SNAME , host, service, (char *) 0);

	    openlog ("fhost", LOG_CONS | LOG_NDELAY | LOG_PID, LOG_DAEMON);
	    log_err (use_syslog, P_ERROR, "connect");
	}

	/*
	  If we do connect then the server is active. Send
	  the localhost name, the remote host's name and
	  the name of the service that was requested.
	*/

	i = 0;
	j = 0;
	while ((c = localhost[i++]) != '\0')
		mess[j++] = c;
	mess[j++] = '\0';

	i = 0;
	while ((c = host[i++]) != '\0')
		mess[j++] = c;
	mess[j++] = '\0';

	i = 0;
	while ((c = service[i++]) != '\0')
		mess[j++] = c;
	mess[j++] = '\0';

	send (s, mess, j, 0);

	/*
	  Terminate the connection.
	*/

	close(s);

	exit(0);
}

void print_usage (int exit_flag)
{
  printf("\n");
  printf("Usage: fhost [-n] [-s] @host service\n");
  printf("   or: fhost -v\n");
  printf("   or: fhost -h\n");
  printf("where\n");
  printf("       -n = also run nmap\n");
  printf("       -s = errors to stdout\n");
  printf("       -v = version number\n");
  printf("       -h = this help message\n");
  printf("    @host = @hostaddress\n");
  printf("  service = service name\n");

  exit (exit_flag);
}

