/*
	This is the network domain finger host client. It 
	simply reads in the remote host name and the requested
	service and sends it to the server program via an internet
	socket.

    Copyright (C) 1996 <Ed Alley, Email: wea@llnl.gov>

*/

#include "fhost.h"

main(argc, argv)
int argc;
char **argv;
{
	char c;
	char localhost[MAXCHARS],host[MAXCHARS], service[MAXCHARS];
	char mess[MAXMESS];
	int i, j, s, len, nbr, cl, use_syslog, use_nmap;
	struct sockaddr_in sin;
	extern char *optarg;
	extern int opterr, optind, optopt;

	openlog ("fhost", LOG_CONS | LOG_NDELAY | LOG_PID, LOG_DAEMON);

	/*
	  Number of arguments must be less than five.
	*/

	if (argc > 4) {
	  syslog (LOG_ERR, "Too many arguments!\n");
	  syslog (LOG_ERR, "For usage enter the command: fhost -h\n");
	  exit (1);
	}

	/*
	  Check argument lengths (must be less than MAXCHARS-1 characters).
	*/

	j = 0;
	for (i=0; i<argc; i++) {
	 if (strlen(argv[i]) > MAXCHARS-1) {
	  j = 1;
	  syslog(LOG_ERR,"Argument length exceeded. ...Exiting\n");
	  syslog(LOG_ERR,"%.32s: Possible buffer overrun attack.\n",
		 argv[i]);
	 }
	}

	if (j) {
	  syslog (LOG_ERR, "For usage enter the command: fhost -h\n");
	  exit (1);
	}

	/* Process the command line options. */

	use_syslog = 1;
	use_nmap   = 0;

	while ((cl = getopt(argc, argv, "hsv")) != -1) {
          switch (cl) {
	    case 's':
	      use_syslog = 0;
	      break;
	    case 'v':
	      printf("Fhost version number: "VERSION"\n");
	      exit (0);
	    case 'h':
	    default:
	      print_usage (0);
          }
        }

	if (argc-optind < 2) {
	  syslog(LOG_ERR, "Incorrect number of arguments!\n");
	  syslog(LOG_ERR, "For usage enter the command: fhost -h\n");
	  exit (1);
	}

	/*
	  Load arguments: arg[1] = "@remote_host_name"
			  arg[2] = "requested_service"
	*/

	strcpy (localhost, LOCALHOST);

	i = 0;
	while ((c = argv[optind][i]) != '\0')
	  host[i++] = c;
	host[i]   = '\0';

	/*
	  Check to see if we have a host name.
	*/

	if (host[0] != '@') {
	  syslog(LOG_ERR, "Hostname error: %s\n", host);
	  syslog(LOG_ERR, "For usage enter the command: fhost -h\n");
	  exit (1);
	}

	i = 0;
	while ((c = argv[optind+1][i]) != '\0')
	  service[i++] = c;
	service[i] = '\0';

	/*
	  Get an internet stream socket.
	*/

	if ((s = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	  log_err (use_syslog, P_ERROR, "fhost: socket");

	/*
	  Store the address info into the socket structure.
	*/

	bzero((char *) &sin, sizeof(sin));

	sin.sin_family      = AF_INET;
	sin.sin_addr.s_addr = inet_addr(SERV_ADDR);
	sin.sin_port        = htons(SERV_PORT);

	/*
	  Connect to the socket.
	*/

	if (connect(s, (struct sockaddr *) &sin, sizeof(sin)) < 0)
	  log_err (use_syslog, P_ERROR, "connect");

	/*
	  Send the local host's name, the remote host's name
	  and the name of the service that was requested.
	*/

	i = 0;
	j = 0;
	while ((c = localhost[i++]) != '\0')
		mess[j++] = c;
	mess[j++] = '\0';

	i = 0;
	while ((c = host[i++]) != '\0')
		mess[j++] = c;
	mess[j++] = '\0';

	i = 0;
	while ((c = service[i++]) != '\0')
		mess[j++] = c;
	mess[j++] = '\0';

	send(s, mess, j, 0);

	/*
	  Terminate the connection.
	*/

	close(s);

	exit(0);
}

void print_usage (int exit_flag)
{
  printf("\n");
  printf("Usage: fhost [-s] @host service\n");
  printf("   or: fhost -v\n");
  printf("   or: fhost -h\n");
  printf("where\n");
  printf("       -s = errors to stdout\n");
  printf("       -v = version number\n");
  printf("       -h = this help message\n");
  printf("    @host = @hostaddress\n");
  printf("  service = service name\n");

  exit (exit_flag);
}

