/*********************************************************************
 *                                                                   *
 *                      fhost.h include file                         *
 *                                                                   *
 *  It is not necessary to modify any defines here; the defines are  *
 *  set using the user modified include file "defines.h".            *
 *                                                                   *
 *********************************************************************/

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/un.h>

#include <unistd.h>
#include <stdio.h>
#include <syslog.h>

#include "defines.h"    /* User modified include file */

#define MAXCHARS		MAX_CHARS_HOSTNAME
#define MAXMESS			MAX_CHARS_MESSAGE

#define P_ERROR 1
#define SYS_LOG 2

#if defined(FHOST_NET)		/* FhostNET defines */

#include <netinet/in.h>
#include <arpa/inet.h>

#define SERV_PORT		FHOSTD_NET_PORT
#define SERV_ADDR		FHOSTD_NET_ADDRESS

#define LOCALHOST		FHOST_NET_HOST

#elif defined(FHOST_UNIX)	/* FhostUNIX defines */

#define ADDRESS			PATH_TO_UNIX_SOCKET
#define SPATH			PATH_TO_SERVER
#define SNAME			SERVER_NAME

#define LOCALHOST		FHOST_UNIX_HOST

#endif

void print_usage (int);
void log_err (int,int,char*);
