/*******************************************************************
 *                                                                 *
 *  Set each of these defines to your configuration, otherwise,    *
 *  strange things will happen. After setting these defines be     *
 *  sure to throughly test out the fhost-fhostd client server      *
 *  functionality before incorporating them into TCP Wrappers.     *
 *                                                                 *
 *******************************************************************/

#include "version.h"

#define PATH_TO_UNIX_SOCKET	"/var/tmp/fhost_socket"
#define ADDRESS_FOR_MAIL	"root"
#define HOST_TABLE_SIZE		100
#define PATH_TO_MAIL		"/usr/bin/Mail"
#define PATH_TO_SAFE_FINGER	"/usr/local/bin/safe_finger"
#define PATH_TO_NMAP		"/usr/local/bin/nmap"
#define PATH_TO_SERVER		"/usr/local/bin/fhostd"
#define PATH_TO_PID		"/var/run/fhostd.pid"
#define SERVER_NAME		"fhostd"

#define MAX_CHARS_HOSTNAME	255
#define MAX_CHARS_MESSAGE	1024

#define FHOSTD_TIMEOUT		1020L 	/* 17 mins. */

#if defined(FHOST_UNIX)		/* FhostUNIX related defines */

# define FHOST_UNIX_HOST	"localhost"	     /* Client hostname */
# define FHOSTD_UNIX_HOST	FHOST_UNIX_HOST	     /* Server hostname */

#elif defined(FHOST_NET)	/* FhostNET related defines */

# define FHOSTD_NET_PORT	6789		     /* Server port */
# define FHOSTD_NET_ADDRESS	"10.0.0.10"	     /* Server ip-address */
# define FHOSTD_NET_HOST	"virt.brew.net"      /* Server hostname */

# define FHOST_NET_HOST		"red.brew.com"	     /* Client hostname */

#endif
